% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbGetRowsAffected,DatabaseConnectorJdbcResult-method}
\alias{dbGetRowsAffected,DatabaseConnectorJdbcResult-method}
\title{The number of rows affected}
\usage{
\S4method{dbGetRowsAffected}{DatabaseConnectorJdbcResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \link[DBI:DBIResult-class]{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbGetRowsAffected()} returns a scalar number (integer or numeric),
the number of rows affected by a data manipulation statement
issued with \code{\link[DBI:dbSendStatement]{dbSendStatement()}}.
The value is available directly after the call
and does not change after calling \code{\link[DBI:dbFetch]{dbFetch()}}.
\code{NA_integer_} or \code{NA_numeric_} are allowed if the number of rows affected is not known.

For queries issued with \code{\link[DBI:dbSendQuery]{dbSendQuery()}},
zero is returned before
and after the call to \code{dbFetch()}.
\code{NA} values are not allowed.
}
\description{
This method returns the number of rows that were added, deleted, or updated
by a data manipulation statement.

}
\seealso{
Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbColumnInfo}()},
\code{\link[DBI]{dbFetch}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetRowCount}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbQuoteString}()}

Other command execution generics: 
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbSendStatement}()}
}
