% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_6DTWUMI_1gap.R
\name{DTWUMI_1gap_imputation}
\alias{DTWUMI_1gap_imputation}
\title{Imputation of a large gap based on DTW for multivariate signals}
\usage{
DTWUMI_1gap_imputation(data, id_sequence, begin_gap, gap_size,
  DTW_method = "DTW", threshold_cos = 0.995, thresh_cos_stop = 0.8,
  step_threshold = 2, ...)
}
\arguments{
\item{data}{a multivariate signals containing gaps}

\item{id_sequence}{id of the sequence containing the gap to fill (corresponding to the column number)}

\item{begin_gap}{id of the begining of the gap to fill}

\item{gap_size}{size of the gap to fill}

\item{DTW_method}{DTW method used for imputation ("DTW", "DDTW", "AFBDTW"). By default "DTW"}

\item{threshold_cos}{threshold used to define similar sequences to the query}

\item{thresh_cos_stop}{Define the lowest cosine threshold acceptable to find a similar window to the query}

\item{step_threshold}{step used within the loops determining the threshold and the most similar sequence to the query}

\item{...}{additional arguments from dtw() function}
}
\value{
returns a list containing the following elements:
\itemize{
 \item{imputed_values: }{output vector containing the imputation proposal}
 \item{id_imputation: }{a vector containing the position of the imputed values extracted}
 \item{id_sim_win: }{a vector containing the position of the similar window to the query}
 \item{id_gap: }{a vector containing the position gap considered}
 \item{id_query: }{a vector containing the position of the query}
}
}
\description{
Fills a gap of size 'gap_size' begining at the position 'begin_gap' within a multivariate signal using DTW.
}
\examples{
data(dataDTWUMI)
dataDTWUMI_gap <- dataDTWUMI[["incomplete_signal"]]
t <- 207 ; T <- 40
imputation <- DTWUMI_1gap_imputation(dataDTWUMI_gap, id_sequence=1, t, T)
plot(dataDTWUMI_gap[, 1], type = "l", lwd = 2)
lines(y = imputation$imputed_values, x = imputation$id_gap, col = "red")
lines(y = dataDTWUMI_gap[imputation$id_query, 1], x = imputation$id_query, col = "green")
lines(y = dataDTWUMI_gap[imputation$id_sim_win, 1], x = imputation$id_sim_win, col = "blue")
lines(y = dataDTWUMI_gap[imputation$id_imputation, 1], x = imputation$id_imputation, col = "orange")
}
\author{
DEZECACHE Camille, PHAN Thi Thu Hong, POISSON-CAILLAULT Emilie
}
