% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_doi.R
\name{add_doi}
\alias{add_doi}
\title{Add DOIs to References in a Word Document}
\usage{
add_doi(input_path, output_path, reference_lines = 50)
}
\arguments{
\item{input_path}{Character. Path to the input 'Word' document (.docx) containing references.
Can be absolute (e.g., "C:/Users/.../references.docx") or relative (e.g., "./references.docx").}

\item{output_path}{Character. Path where the output 'Word' document with DOIs will be saved.
If the file exists, it will be overwritten.}

\item{reference_lines}{Numeric. Number of lines from the end of the document to treat as references. Default is 50.
Only lines with more than 30 characters are processed.}
}
\value{
Character vector of references with appended DOIs. References that could not be matched return "NA".
}
\description{
This function reads a 'Word' document containing bibliographic references, fetches their corresponding DOIs
via the 'CrossRef' API, and writes a new 'Word' document with the DOIs appended to each reference.
}
\examples{
\donttest{
# Basic usage: fetch DOIs for last 50 lines in a 'Word' document
add_doi(
  input_path  = "E:/references.docx",
  output_path = "E:/references_doi.docx",
  reference_lines = 50
)

# Notes:
# - input_path must exist and contain references.
# - output_path will be overwritten if it exists.
# - Some references may return DOI "NA" if not found on 'CrossRef'.
}
}
