% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/online_sir_lfm.R
\name{online_sir_lfm}
\alias{online_sir_lfm}
\title{Online Sufficient Dimension Reduction for Laplace Factor Model (LFM)}
\usage{
online_sir_lfm(
  X,
  K_true = NULL,
  K_max = NULL,
  c_robust = 1.345,
  eta = "auto",
  method = "gradient",
  verbose = FALSE
)
}
\arguments{
\item{X}{A matrix or data stream of size n x p (rows = observations, cols = features). Can be processed row-by-row in streaming setting.}

\item{K_true}{Optional true dimension (for monitoring). If NULL, will estimate online via BIC-like criterion.}

\item{K_max}{Maximum candidate dimension for online selection (default = min(10, ncol(X))).}

\item{c_robust}{Robustness scale for tanh transformation (default = 1.345, approx. 0.95 efficiency for Gaussian).}

\item{eta}{Learning rate schedule: either a function of t, or "auto" for 1/t.}

\item{method}{Optimization method: "gradient" for gradient-based updates with learning rate, or "perturbation" for direct eigenvector computation of the moment matrix (default = "gradient").}

\item{verbose}{Logical; if TRUE, prints progress and estimated K at each step.}
}
\value{
A list with:
\item{B_hat}{Final estimated basis matrix (p x K_est)}
\item{K_est}{Estimated structural dimension}
\item{B_path}{List of B estimates over time (optional, for debugging)}
\item{loss}{Reconstruction loss trace (optional)}
\item{method_used}{The optimization method actually used}
}
\description{
Implements an online SIR algorithm tailored for LFM data, using a proxy response constructed from the current subspace estimate and robust updates to handle heavy-tailed noise. The algorithm supports two optimization methods: gradient-based updates and perturbation-based updates.
}
\examples{
set.seed(123)
n <- 500; p <- 20; m <- 3
B_true <- qr.Q(qr(matrix(rnorm(p * m), p, m)))
f <- matrix(rnorm(n * m), n, m)
eps <- matrix(rexp(n * p, rate = 1) - 1, n, p) # Asymmetric Laplace-like noise
X <- f \%*\% t(B_true) + eps

# Using gradient method (default)
out_grad <- online_sir_lfm(X, K_true = m, verbose = TRUE)

# Using perturbation method
out_pert <- online_sir_lfm(X, K_true = m, method = "perturbation", verbose = TRUE)

}
