% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threeganova.sim.R
\name{threeganova.sim}
\alias{threeganova.sim}
\title{threeganova.sim}
\usage{
threeganova.sim(group_n, f_sqr, sd.1)
}
\arguments{
\item{group_n}{a (non-empty) numeric value of desired sample size per group}

\item{f_sqr}{a (non-empty) numeric value of desired Cohen's f squared value}

\item{sd.1}{a (non-empty) numeric value of desired standard deviation ratio}
}
\value{
a dataframe containing scores "y", grouping factor "group", and residual errors.
}
\description{
simulate three-group anova data
}
\examples{
sample.3g=threeganova.sim(1000,.16,5) #data of n=1000, sd1=sd3=1 and sd2=5, and f^2=.16
colnames(sample.3g) #examine the column names
dim(sample.3g) #examine the data structure
aggregate(sample.3g$y,sd,by=list(sample.3g$group)) #check group standard deviations
}
