% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{adjust_p}
\alias{adjust_p}
\title{Adjust p-values using a specified method}
\usage{
adjust_p(p_values, method = "BH")
}
\arguments{
\item{p_values}{A numeric vector of raw p-values.}

\item{method}{A character string specifying the p‑value adjustment
method.  Passed directly to \code{p.adjust}.  Defaults to "BH"
(Benjamini–Hochberg).  See \code{p.adjust.methods} for other
options.}
}
\value{
A numeric vector of adjusted p-values of the same length as
\code{p_values}.
}
\description{
A thin wrapper around \code{stats::p.adjust} that defaults to the
Benjamini–Hochberg procedure.  Useful for unifying multiple
testing adjustments across the package.
}
