% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_Hanwell.R
\name{tidy_Hanwell}
\alias{tidy_Hanwell}
\title{Tidy Hanwell EMS Data}
\usage{
tidy_Hanwell(
  EMS_datapath,
  Site = "Site",
  MinMax = FALSE,
  sheet = "Hanwell",
  ...
)
}
\arguments{
\item{EMS_datapath}{Character string specifying the
file path to the Hanwell EMS data file.}

\item{Site}{Character string specifying site name to add as a column.
Default is "Site".}

\item{MinMax}{Logical flag; if TRUE, reads Min-Max format,
otherwise reads raw data. Default is FALSE.}

\item{sheet}{Optional, Excel sheet name for reading Excel files. The default is "Hanwell"}

\item{...}{Additional arguments passed to \code{readxl::read_excel} for Excel reading.}
}
\value{
A tibble containing tidied Hanwell EMS data, with columns including:
\describe{
  \item{Site}{Character, site name as specified by \code{Site} argument.}
  \item{Sensor}{Character, sensor identifier extracted from the file or metadata.}
  \item{Date}{POSIXct datetime of the measurement.}
  \item{Temp}{Numeric temperature measurement in °C (average for MinMax).}
  \item{RH}{Numeric relative humidity measurement in \% (average for MinMax).}
  \item{TempMin, TempMax, RHMin, RHMax}{(Only for MinMax reports) Numeric min/max values of Temp and RH.}
}
}
\description{
This function tidies Hanwell Environmental Monitoring System (EMS) data from either
Excel sheets or CSV files.

- Default mode (MinMax = FALSE): Reads raw date, temperature, and humidity data.
- Min-Max mode (MinMax = TRUE): Under development to read min-max average data (CSV only).
}
\examples{

\donttest{
# Example usage: hanwell_data <- tidy_Hanwell("path/to/your/hanwell_data.csv")
}

# mydata file
filepath <- data_file_path("mydata.xlsx")

tidy_Hanwell(filepath, sheet = "Hanwell", Site = "London") |> head()


}
