% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCohortOverlap.R
\name{plotCohortOverlap}
\alias{plotCohortOverlap}
\title{Plot the result of summariseCohortOverlap.}
\usage{
plotCohortOverlap(
  result,
  uniqueCombinations = TRUE,
  facet = c("cdm_name", "cohort_name_reference"),
  colour = "variable_name",
  style = NULL,
  .options = lifecycle::deprecated()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{uniqueCombinations}{Whether to restrict to unique reference and
comparator comparisons.}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}

\item{style}{Visual theme to apply. Character, or \code{NULL}. If a character, this
may be either the name of a built-in style (see \code{plotStyle()}), or a path to
a \code{.yml} file that defines a custom style. If NULL, the function will use the
explicit default style, unless a global style option is set (see
\code{setGlobalPlotOptions()}), or a _brand.yml file is present (in that order).
Refer to the package vignette on styles to learn more.}

\item{.options}{deprecated.}
}
\value{
A ggplot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)

cdm <- mockCohortCharacteristics()

overlap <- summariseCohortOverlap(cdm$cohort2)

plotCohortOverlap(overlap, uniqueCombinations = FALSE)

}

}
