% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sleep_detection.R
\name{sleep_detection}
\alias{sleep_detection}
\title{Estimate precise sleep_wake cycles using CircaCP algorithm}
\usage{
sleep_detection(clean_df, thr = 0.2, dist = "ZAG")
}
\arguments{
\item{clean_df}{Minute-level \code{data.frame} with at least \code{Activity}. Additional
columns are preserved.}

\item{thr}{Numeric threshold in [0, 1] applied to a rescaled cosinor fit.}

\item{dist}{Character method key (e.g., \code{"ZAG"}); interpreted by your rule set.}
}
\value{
a data.frame augmenting the input \code{df} including the following additional variables:
\describe{
\item{cosinor}{fitted cosine curve}
\item{label.cos}{circadian cycle estimated by dichotimized cosine curve}
\item{label.sw}{sleep-wake cycle estimated by CircaCP}
\item{Activity_norm}{range-normalized activity levels}
}
}
\description{
It first uses a 24 h cosinor fit (via \code{\link[=sleep_cos]{sleep_cos()}}) and a chosen thresholding rule to
label each minute as sleep (\code{label.sw = 1}) or wake (\code{label.sw = 0}).
Reference: Shanshan Chen, and Xinxin Sun.Validating CircaCP:
a generic sleep–wake cycle detection algorithm for unlabelled actigraphy data.
Royal Society Open Science 11, no. 5 (2024): 231468.
}
\seealso{
\code{\link[=screen_wear]{screen_wear()}}, \code{\link[=sleep_cos]{sleep_cos()}},\code{\link[=cp_detect]{cp_detect()}}, \code{\link[=extract_sleep_metrics]{extract_sleep_metrics()}}
}
