# Function to return plot object #
get_diagnostic <- function(xpdb, treeSelected, software, input,
                           isCertaraTheme, isDefaultText, isDefaultArrangement, isExtraHlines, isShowLegend,
                           selectedCovariate, selectedFacet, cols, covCols, catCov, contCov, covTrees,
                           pageNumber, hasResetInfo, darwin_data, hasEta, hasParam){

    if(length(treeSelected) == 0){
      treeSelected <- ""
    }

   if(treeSelected %in% covTrees || treeSelected == "Covariate QQ"){
      if(length(covCols) == 0 || is.null(selectedCovariate)){
         if (software == "NONMEM") {
            stop("No covariates found. Check NONMEM $TABLE statements.")
         } else {
            stop("No covariates found.")
         }
      } else if(selectedCovariate %in% contCov){
         covPlotType <- set_plot_scatter_type(input$displayPoints, input$displayLines, input$displaySmoothing, input$displayText)
      } else {
         covPlotType <- "b"
      }
   }

   arrange.ncol = input$arrangeColNum
   arrange.nrow = input$arrangeRowNum
   axis.color = input$colorAxis
   axis.face = input$faceAxis
   axis.font = font_to_family(input$fontAxis)
   axis.scale = input$selectedAxisScale
   axis.size = input$sizeAxis
   axis.x.label = input$xlab
   axis.y.label = input$ylab
   background.border = input$isShowBorder
   background.color = input$colorBackground
   background.gridlines = input$isShowGridLines
   boxplot.alpha = input$alphaBoxPlot/100
   boxplot.line.color = input$colorBoxPlot
   boxplot.fill.color = input$fillBoxPlot
   axis.log.type = set_log_type(input$isLogX, input$isLogY)
   caption.color = input$colorCaption
   caption.face = input$faceCaption
   caption.font = font_to_family(input$fontCaption)
   caption.size = input$sizeCaption
   caption.text = input$textCaption
   density.alpha = input$alphaDensity/100
   density.line.color = input$colorDensity
   density.fill.color = input$fillDensity
   density.line.type = input$typeLineDensity
   density.size = input$sizeDensity
   facet.ncol = input$arrangeColNum
   facet.nrow = input$arrangeRowNum
   guide.line.alpha = input$alphaLineGuide/100
   guide.line.color = input$colorLineGuide
   guide.line.size = input$sizeLineGuide
   guide.line.type = input$typeLineGuide
   guide.line.extra.y1 = input$hLine1
   guide.line.extra.y2 = input$hLine2
   hist.alpha = input$alphaHistogram/100
   hist.line.color = input$colorHistogram
   hist.fill.color = input$fillHistogram
   hist.line.type = input$typeLineHistogram
   hist.nbins = input$nbinsHistogram
   hist.size = input$sizeHistogram
   indplots.legend.position = input$legendPosition
   indplots.line.color.IPRED = input$colorLineIPRED
   indplots.line.color.PRED = input$colorLinePRED
   indplots.line.type.IPRED = input$typeLineIPRED
   indplots.line.type.PRED = input$typeLinePRED
   indplots.point.alpha.DV = input$alphaPointDV / 100
   indplots.point.color.DV = input$colorPointDV
   indplots.point.size.DV = input$sizePointDV
   indplots.point.shape.DV = change_point_shape(input$shapePointDV)
   line.alpha = input$alphaLine/100
   line.color = input$colorLine
   line.size = input$sizeLine
   line.type = input$typeLine
   outlier.alpha = input$alphaOutlier/100
   outlier.color = input$colorOutlier
   outlier.shape = change_outlier_shape(input$shapeOutlier, input$displayOutliers)
   outlier.size = input$sizeOutlier
   plot.distribution.type = set_plot_distribution_type(input$displayHistogram, input$displayDensity, input$displayRug)
   plot.scatter.guide = input$displayRefLine
   plot.scatter.smoothing = input$smoothingType
   plot.scatter.type = set_plot_scatter_type(input$displayPoints, input$displayLines, input$displaySmoothing, input$displayText)
   point.alpha = input$alphaPoint/100
   point.color = input$colorPoint
   point.shape = change_point_shape(input$shapePoint)
   point.size = input$sizePoint
   rug.color = input$colorRug
   rug.line.size = input$sizeLineRug
   rug.sides = set_rug_type(input$positionRug)
   smooth.line.alpha = input$alphaLineSmooth/100
   smooth.line.color = input$colorLineSmooth
   smooth.line.size = input$sizeLineSmooth
   smooth.line.type = input$typeLineSmooth
   smooth.span = input$spanSmooth
   subtitle.color = input$colorSubtitle
   subtitle.face = input$faceSubtitle
   subtitle.font = font_to_family(input$fontSubtitle)
   subtitle.size = input$sizeSubtitle
   subtitle.text = input$textSubtitle
   title.color = input$colorTitle
   title.face = input$faceTitle
   title.font = font_to_family(input$fontTitle)
   title.size = input$sizeTitle
   title.text = input$textTitle

   if (treeSelected %in% c("Fitness vs Iteration", "Penalties vs Iteration")) {
     title.text <- input$textDarwinTitle
     subtitle.text <- input$textDarwinSubtitle
     caption.text <- input$textDarwinCaption
     axis.x.label <- input$xlabDarwin
     axis.y.label <- input$ylabDarwin
   }

    if(selectedFacet == "none"){
      selectedFacet <- NULL
    }


   if(isDefaultArrangement){
      arrangeRows <- NULL
      arrangeCols <- NULL
      pageNumber <- NULL
   } else {
     arrangeRows <- input$arrangeRowNum
     arrangeCols <- input$arrangeColNum
   }

   if(software == "NONMEM"){


      varname <- sub(" .*", "", treeSelected)
      varname <- gsub("\\|", "", varname)

      check_vars(c(varname, "TAD", "PRED", "IPRED", "TIME"), treeSelected, cols)
      check_types(varname, hasEta, hasParam)

      if("DVID" %in% cols){
         facetObs <- "DVID"
      } else {
         facetObs <- NULL
      }

      ofv <- "Ofv: @ofv"
      resetCol <- NULL

      userPlot <- metaExpr({
         ..(xpdb)
      })
   } else {
      facetObs <- "ObsName"
      ofv <- "-2LL: @ofv"
      if(any(hasResetInfo)){
      resetCol <- "WhichReset"
      } else {
         resetCol <- NULL
      }

      userPlot <- metaExpr({
         ..(xpdb) %>%
            filter(!is.na(ObsName))
      })
   }

# ABS IWRES vs IPRED ----
    if(treeSelected == "|IWRES| vs IPRED" ) {
          userPlot <- metaExpr({
             ..(userPlot) %>%
                set_var_types(pred = 'IPRED') %>%
                absval_res_vs_pred(res = "IWRES",
                                   type = ..(plot.scatter.type),
                                   facets = c(..(facetObs), ..(selectedFacet)),
                                   nrow = ..(arrangeRows),
                                   ncol = ..(arrangeCols),
                                   scales = ..(axis.scale),
                                   title = "|IWRES| vs @x | @run",
                                   subtitle =  ..(paste0(ofv, ", Eps shrink: @epsshk")),
                                   page = ..(pageNumber),
                                   smooth_method = ..(plot.scatter.smoothing),
                                   smooth_span = ..(smooth.span),
                                   smooth_linetype = ..(smooth.line.type),
                                   smooth_color = ..(smooth.line.color),
                                   smooth_size = ..(smooth.line.size),
                                   log = ..(axis.log.type),
                                   guide = ..(plot.scatter.guide),
                                   guide_linetype = ..(guide.line.type),
                                   guide_alpha = ..(guide.line.alpha),
                                   guide_color = ..(guide.line.color),
                                   guide_size = ..(guide.line.size),
                                   point_shape = ..(point.shape),
                                   point_color = ..(point.color),
                                   point_alpha = ..(point.alpha),
                                   point_size = ..(point.size),
                                   point_stroke = 1,
                                   line_color = ..(line.color),
                                   line_alpha = ..(line.alpha),
                                   line_size = ..(line.size),
                                   line_linetype = ..(line.type)) +
                ylab("|IWRES|")
          })
      # ABS IWRES vs TAD ----
      } else if(treeSelected == "|IWRES| vs TAD") {
        userPlot <- metaExpr({
          ..(userPlot) %>%
            set_var_types(idv = 'TAD') %>%
          absval_res_vs_idv(res = "IWRES",
                            type = ..(plot.scatter.type),
                            facets = c(..(facetObs), ..(selectedFacet)),
                            nrow = ..(arrangeRows),
                            ncol = ..(arrangeCols),
                            scales = ..(axis.scale),
                            title = "|IWRES| vs @x | @run",
                            subtitle =  ..(paste0(ofv, ", Eps shrink: @epsshk")),
                            page = ..(pageNumber),
                            smooth_method = ..(plot.scatter.smoothing),
                            smooth_span = ..(smooth.span),
                            smooth_linetype = ..(smooth.line.type),
                            smooth_color = ..(smooth.line.color),
                            smooth_size = ..(smooth.line.size),
                            log = ..(axis.log.type),
                            guide = ..(plot.scatter.guide),
                            guide_linetype = ..(guide.line.type),
                            guide_alpha = ..(guide.line.alpha),
                            guide_color = ..(guide.line.color),
                            guide_size = ..(guide.line.size),
                            point_shape = ..(point.shape),
                            point_color = ..(point.color),
                            point_alpha = ..(point.alpha),
                            point_size = ..(point.size),
                            point_stroke = 1,
                            line_color = ..(line.color),
                            line_alpha = ..(line.alpha),
                            line_size = ..(line.size),
                            line_linetype = ..(line.type)) +
                            ylab("|IWRES|")
        })
        # ABS IWRES vs IVAR ----
    } else if(treeSelected == "|IWRES| vs IVAR") {
        userPlot <- metaExpr({
           ..(userPlot) %>%
          absval_res_vs_idv(res = "IWRES",
                            type = ..(plot.scatter.type),
                            facets = c(..(facetObs), ..(selectedFacet)),
                            nrow = ..(arrangeRows),
                            ncol = ..(arrangeCols),
                            scales = ..(axis.scale),
                            title = "|IWRES| vs @x | @run",
                            subtitle =  ..(paste0(ofv, ", Eps shrink: @epsshk")),
                            page = ..(pageNumber),
                            smooth_method = ..(plot.scatter.smoothing),
                            smooth_span = ..(smooth.span),
                            smooth_linetype = ..(smooth.line.type),
                            smooth_color = ..(smooth.line.color),
                            smooth_size = ..(smooth.line.size),
                            log = ..(axis.log.type),
                            guide = ..(plot.scatter.guide),
                            guide_linetype = ..(guide.line.type),
                            guide_alpha = ..(guide.line.alpha),
                            guide_color = ..(guide.line.color),
                            guide_size = ..(guide.line.size),
                            point_shape = ..(point.shape),
                            point_color = ..(point.color),
                            point_alpha = ..(point.alpha),
                            point_size = ..(point.size),
                            point_stroke = 1,
                            line_color = ..(line.color),
                            line_alpha = ..(line.alpha),
                            line_size = ..(line.size),
                            line_linetype = ..(line.type)) +
                            ylab("|IWRES|")
          })
        # CWRES vs PRED ----
       } else if(treeSelected == "CWRES vs PRED"){
          userPlot <- metaExpr({
             ..(userPlot) %>%
              res_vs_pred(res = "CWRES",
                          type = ..(plot.scatter.type),
                          facets = c(..(facetObs), ..(selectedFacet)),
                          nrow = ..(arrangeRows),
                          ncol = ..(arrangeCols),
                          scales = ..(axis.scale),
                          subtitle = ..(ofv),
                          page = ..(pageNumber),
                          smooth_method = ..(plot.scatter.smoothing),
                          smooth_span = ..(smooth.span),
                          smooth_linetype = ..(smooth.line.type),
                          smooth_color = ..(smooth.line.color),
                          smooth_size = ..(smooth.line.size),
                          log = ..(axis.log.type),
                          guide = ..(plot.scatter.guide),
                          guide_linetype = ..(guide.line.type),
                          guide_alpha = ..(guide.line.alpha),
                          guide_color = ..(guide.line.color),
                          guide_size = ..(guide.line.size),
                          point_shape = ..(point.shape),
                          point_color = ..(point.color),
                          point_alpha = ..(point.alpha),
                          point_size = ..(point.size),
                          point_stroke = 1,
                          line_color = ..(line.color),
                          line_alpha = ..(line.alpha),
                          line_size = ..(line.size),
                          line_linetype = ..(line.type)) #ref line is guide argumenti.e. guide = TRUE
          })
# CWRES vs TAD ----
   } else if(treeSelected == "CWRES vs TAD") {
       userPlot <- metaExpr({
          ..(userPlot) %>%
             set_var_types(idv = "TAD") %>%
           res_vs_idv(res = "CWRES",
                      type = ..(plot.scatter.type),
                      facets = c(..(facetObs), ..(selectedFacet)),
                      scales = ..(axis.scale),
                      nrow = ..(arrangeRows),
                      ncol = ..(arrangeCols),
                      subtitle = ..(ofv),
                      page = ..(pageNumber),
                      smooth_method = ..(plot.scatter.smoothing),
                      smooth_span = ..(smooth.span),
                      smooth_linetype = ..(smooth.line.type),
                      smooth_color = ..(smooth.line.color),
                      smooth_size = ..(smooth.line.size),
                      log = ..(axis.log.type),
                      guide = ..(plot.scatter.guide),
                      guide_linetype = ..(guide.line.type),
                      guide_alpha = ..(guide.line.alpha),
                      guide_color = ..(guide.line.color),
                      guide_size = ..(guide.line.size),
                      point_shape = ..(point.shape),
                      point_color = ..(point.color),
                      point_alpha = ..(point.alpha),
                      point_size = ..(point.size),
                      point_stroke = 1,
                      line_color = ..(line.color),
                      line_alpha = ..(line.alpha),
                      line_size = ..(line.size),
                      line_linetype = ..(line.type))
       })
# CWRES vs IVAR ----
   } else if(treeSelected == "CWRES vs IVAR") {
       userPlot <- metaExpr({
          ..(userPlot) %>%
           res_vs_idv(res = "CWRES",
                      type = ..(plot.scatter.type),
                      facets = c(..(facetObs), ..(selectedFacet)),
                      scales = ..(axis.scale),
                      nrow = ..(arrangeRows),
                      ncol = ..(arrangeCols),
                      subtitle = ..(ofv),
                      page = ..(pageNumber),
                      smooth_method = ..(plot.scatter.smoothing),
                      smooth_span = ..(smooth.span),
                      smooth_linetype = ..(smooth.line.type),
                      smooth_color = ..(smooth.line.color),
                      smooth_size = ..(smooth.line.size),
                      log = ..(axis.log.type),
                      guide = ..(plot.scatter.guide),
                      guide_linetype = ..(guide.line.type),
                      guide_alpha = ..(guide.line.alpha),
                      guide_color = ..(guide.line.color),
                      guide_size = ..(guide.line.size),
                      point_shape = ..(point.shape),
                      point_color = ..(point.color),
                      point_alpha = ..(point.alpha),
                      point_size = ..(point.size),
                      point_stroke = 1,
                      line_color = ..(line.color),
                      line_alpha = ..(line.alpha),
                      line_size = ..(line.size),
                      line_linetype = ..(line.type))
       })
       # ECWRES vs PRED ----
   } else if(treeSelected == "ECWRES vs PRED"){
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "ECWRES" ) %>%
         res_vs_pred(res = "ECWRES",
                   type = ..(plot.scatter.type),
                   facets = c(..(facetObs), ..(selectedFacet)),
                   scales = ..(axis.scale),
                   nrow = ..(arrangeRows),
                   ncol = ..(arrangeCols),
                   subtitle = ..(ofv),
                   page = ..(pageNumber),
                   smooth_method = ..(plot.scatter.smoothing),
                   smooth_span = ..(smooth.span),
                   smooth_linetype = ..(smooth.line.type),
                   smooth_color = ..(smooth.line.color),
                   smooth_size = ..(smooth.line.size),
                   log = ..(axis.log.type),
                   guide = ..(plot.scatter.guide),
                   guide_linetype = ..(guide.line.type),
                   guide_alpha = ..(guide.line.alpha),
                   guide_color = ..(guide.line.color),
                   guide_size = ..(guide.line.size),
                   point_shape = ..(point.shape),
                   point_color = ..(point.color),
                   point_alpha = ..(point.alpha),
                   point_size = ..(point.size),
                   point_stroke = 1,
                   line_color = ..(line.color),
                   line_alpha = ..(line.alpha),
                   line_size = ..(line.size),
                   line_linetype = ..(line.type)) #ref line is guide argumenti.e. guide = TRUE
     })
     # ECWRES vs TAD ----
   } else if(treeSelected == "ECWRES vs TAD") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(idv = "TAD", res = "ECWRES") %>%
         res_vs_idv(res = "ECWRES",
                    type = ..(plot.scatter.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    subtitle = ..(ofv),
                    page = ..(pageNumber),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
     # ECWRES vs IVAR ----
   } else if(treeSelected == "ECWRES vs IVAR") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "ECWRES") %>%
         res_vs_idv(res = "ECWRES",
                  type = ..(plot.scatter.type),
                  facets = c(..(facetObs), ..(selectedFacet)),
                  scales = ..(axis.scale),
                  nrow = ..(arrangeRows),
                  ncol = ..(arrangeCols),
                  page = ..(pageNumber),
                  subtitle = ..(ofv),
                  page = ..(pageNumber),
                  smooth_method = ..(plot.scatter.smoothing),
                  smooth_span = ..(smooth.span),
                  smooth_linetype = ..(smooth.line.type),
                  smooth_color = ..(smooth.line.color),
                  smooth_size = ..(smooth.line.size),
                  log = ..(axis.log.type),
                  guide = ..(plot.scatter.guide),
                  guide_linetype = ..(guide.line.type),
                  guide_alpha = ..(guide.line.alpha),
                  guide_color = ..(guide.line.color),
                  guide_size = ..(guide.line.size),
                  point_shape = ..(point.shape),
                  point_color = ..(point.color),
                  point_alpha = ..(point.alpha),
                  point_size = ..(point.size),
                  point_stroke = 1,
                  line_color = ..(line.color),
                  line_alpha = ..(line.alpha),
                  line_size = ..(line.size),
                  line_linetype = ..(line.type))
     })
     # EWRES vs PRED ----
   } else if(treeSelected == "EWRES vs PRED"){
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "EWRES" ) %>%
         res_vs_pred(res = "EWRES",
                     type = ..(plot.scatter.type),
                     facets = c(..(facetObs), ..(selectedFacet)),
                     scales = ..(axis.scale),
                     nrow = ..(arrangeRows),
                     ncol = ..(arrangeCols),
                     page = ..(pageNumber),
                     subtitle = ..(ofv),
                     smooth_method = ..(plot.scatter.smoothing),
                     smooth_span = ..(smooth.span),
                     smooth_linetype = ..(smooth.line.type),
                     smooth_color = ..(smooth.line.color),
                     smooth_size = ..(smooth.line.size),
                     log = ..(axis.log.type),
                     guide = ..(plot.scatter.guide),
                     guide_linetype = ..(guide.line.type),
                     guide_alpha = ..(guide.line.alpha),
                     guide_color = ..(guide.line.color),
                     guide_size = ..(guide.line.size),
                     point_shape = ..(point.shape),
                     point_color = ..(point.color),
                     point_alpha = ..(point.alpha),
                     point_size = ..(point.size),
                     point_stroke = 1,
                     line_color = ..(line.color),
                     line_alpha = ..(line.alpha),
                     line_size = ..(line.size),
                     line_linetype = ..(line.type)) #ref line is guide argumenti.e. guide = TRUE
     })
     # EWRES vs TAD ----
   } else if(treeSelected == "EWRES vs TAD") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(idv = "TAD", res = "EWRES") %>%
         res_vs_idv(res = "EWRES",
                    type = ..(plot.scatter.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    subtitle = ..(ofv),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
     # EWRES vs IVAR ----
   } else if(treeSelected == "EWRES vs IVAR") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "EWRES") %>%
         res_vs_idv(res = "EWRES",
                    type = ..(plot.scatter.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    subtitle = ..(ofv),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
     # DV PREDS vs IVAR ----
   } else if(treeSelected == "DV PREDS vs IVAR") {
       userPlot <- metaExpr({
          ..(userPlot) %>%
           dv_preds_vs_idv(type = ..(plot.scatter.type),
                           facets = c(..(facetObs), "variable",  ..(selectedFacet)),
                           scales = ..(axis.scale),
                           nrow = ..(arrangeRows),
                           ncol = ..(arrangeCols),
                           page = ..(pageNumber),
                           subtitle =  ..(paste0(ofv, ", Eps shrink: @epsshk")),
                           smooth_method = ..(plot.scatter.smoothing),
                           smooth_span = ..(smooth.span),
                           smooth_linetype = ..(smooth.line.type),
                           smooth_color = ..(smooth.line.color),
                           smooth_size = ..(smooth.line.size),
                           log = ..(axis.log.type),
                           point_shape = ..(point.shape),
                           point_color = ..(point.color),
                           point_alpha = ..(point.alpha),
                           point_size = ..(point.size),
                           point_stroke = 1,
                           line_color = ..(line.color),
                           line_alpha = ..(line.alpha),
                           line_size = ..(line.size),
                           line_linetype = ..(line.type))
       })
       # DV vs IPRED ----
   } else if(treeSelected == "DV vs IPRED") {
       userPlot <- metaExpr({
          ..(userPlot) %>%
          dv_vs_ipred(type = ..(plot.scatter.type),
                      facets = c(..(facetObs), ..(selectedFacet)),
                      scales = ..(axis.scale),
                      nrow = ..(arrangeRows),
                      ncol = ..(arrangeCols),
                      page = ..(pageNumber),
                      subtitle = ..(paste0(ofv, ", Eps shrink: @epsshk")),
                      guide = ..(plot.scatter.guide),
                      guide_linetype = ..(guide.line.type),
                      guide_alpha = ..(guide.line.alpha),
                      guide_color = ..(guide.line.color),
                      guide_size = ..(guide.line.size),
                      smooth_method = ..(plot.scatter.smoothing),
                      smooth_span = ..(smooth.span),
                      smooth_linetype = ..(smooth.line.type),
                      smooth_color = ..(smooth.line.color),
                      smooth_size = ..(smooth.line.size),
                      log = ..(axis.log.type),
                      point_shape = ..(point.shape),
                      point_color = ..(point.color),
                      point_alpha = ..(point.alpha),
                      point_size = ..(point.size),
                      point_stroke = 1,
                      line_color = ..(line.color),
                      line_alpha = ..(line.alpha),
                      line_size = ..(line.size),
                      line_linetype = ..(line.type))
       })
       # DV vs PRED ----
   } else if(treeSelected == "DV vs PRED") {
       userPlot <- metaExpr({
          ..(userPlot) %>%
         dv_vs_pred(type = ..(plot.scatter.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    subtitle = ..(ofv),
                    page = ..(pageNumber),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
       })
      # DV vs IVAR ----
   } else if(treeSelected == "DV vs IVAR") {
       userPlot <- metaExpr({
          ..(userPlot) %>%
         dv_vs_idv(type = ..(plot.scatter.type),
                   facets = c(..(facetObs), ..(selectedFacet)),
                   scales = ..(axis.scale),
                   nrow = ..(arrangeRows),
                   ncol = ..(arrangeCols),
                   page = ..(pageNumber),
                   subtitle = ..(ofv),
                   smooth_method = ..(plot.scatter.smoothing),
                   smooth_span = ..(smooth.span),
                   smooth_linetype = ..(smooth.line.type),
                   smooth_color = ..(smooth.line.color),
                   smooth_size = ..(smooth.line.size),
                   log = ..(axis.log.type),
                   point_shape = ..(point.shape),
                   point_color = ..(point.color),
                   point_alpha = ..(point.alpha),
                   point_size = ..(point.size),
                   point_stroke = 1,
                   line_color = ..(line.color),
                   line_alpha = ..(line.alpha),
                   line_size = ..(line.size),
                   line_linetype = ..(line.type))
       })

       # PRED vs IVAR ----
   } else if(treeSelected == "PRED vs IVAR") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
       pred_vs_idv(type = ..(plot.scatter.type),
                 facets = c(..(facetObs), ..(selectedFacet)),
                 scales = ..(axis.scale),
                 nrow = ..(arrangeRows),
                 ncol = ..(arrangeCols),
                 page = ..(pageNumber),
                 subtitle = ..(ofv),
                 smooth_method = ..(plot.scatter.smoothing),
                 smooth_span = ..(smooth.span),
                 smooth_linetype = ..(smooth.line.type),
                 smooth_color = ..(smooth.line.color),
                 smooth_size = ..(smooth.line.size),
                 log = ..(axis.log.type),
                 point_shape = ..(point.shape),
                 point_color = ..(point.color),
                 point_alpha = ..(point.alpha),
                 point_size = ..(point.size),
                 point_stroke = 1,
                 line_color = ..(line.color),
                 line_alpha = ..(line.alpha),
                 line_size = ..(line.size),
                 line_linetype = ..(line.type))
     })
     # INDIVUDAL PLOTS ----
   } else if(treeSelected == "Individual Plots (IVAR)"){
     userPlot <- metaExpr({
        ..(userPlot) %>%
       ind_plots(facets = c("ID", ..(resetCol), ..(facetObs),  ..(selectedFacet)),
                 scales = ..(axis.scale),
                 subtitle = ..(paste0(ofv, ", Eps shrink: @epsshk")),
                 nrow = ..(ifelse(is.null(arrangeRows), 2, arrangeRows)),
                 ncol = ..(ifelse(is.null(arrangeCols), 3, arrangeCols)),
                 page = ..(ifelse(is.null(pageNumber), 1, pageNumber)),
                 log = ..(axis.log.type),
                 color = c(..(indplots.point.color.DV), ..(indplots.line.color.IPRED ), ..(indplots.line.color.PRED)),
                 point_shape = ..(indplots.point.shape.DV),
                 point_size = ..(indplots.point.size.DV),
                 point_alpha = c(..(indplots.point.alpha.DV), 0, 0),
                 point_stroke = 1,
                 line_linetype = c("blank", ..(indplots.line.type.IPRED),  ..(indplots.line.type.PRED)),
                 line_size = 1,
                 line_alpha = 1)
     })
     # IWRES vs IPRED ----
    } else if(treeSelected == "Individual Plots (TAD)"){
       userPlot <- metaExpr({
          ..(userPlot) %>%
          set_var_types(idv = "TAD") %>%
          ind_plots(facets = c("ID",  ..(resetCol), ..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    subtitle = ..(paste0(ofv, ", Eps shrink: @epsshk")),
                    nrow = ..(ifelse(is.null(arrangeRows), 2, arrangeRows)),
                    ncol = ..(ifelse(is.null(arrangeCols), 3, arrangeCols)),
                    page = ..(ifelse(is.null(pageNumber), 1, pageNumber)),
                    log = ..(axis.log.type),
                    color = c(..(indplots.point.color.DV), ..(indplots.line.color.IPRED ), ..(indplots.line.color.PRED)),
                    point_shape = ..(indplots.point.shape.DV),
                    point_size = ..(indplots.point.size.DV),
                    point_alpha = c(..(indplots.point.alpha.DV), 0, 0),
                    point_stroke = 1,
                    line_linetype = c("blank", ..(indplots.line.type.IPRED),  ..(indplots.line.type.PRED)),
                    line_size = 1,
                    line_alpha = 1) +
               theme(legend.position =  ..(indplots.legend.position))
       })
       # IWRES vs IPRED ----
    } else if(treeSelected == "IWRES vs IPRED"){
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(pred = 'IPRED') %>%
        res_vs_pred(res = "IWRES",
                  type = ..(plot.scatter.type),
                  facets = c(..(facetObs), ..(selectedFacet)),
                  scales = ..(axis.scale),
                  nrow = ..(arrangeRows),
                  ncol = ..(arrangeCols),
                  page = ..(pageNumber),
                  subtitle =  ..(paste0(ofv, ", Eps shrink: @epsshk")),
                  smooth_method = ..(plot.scatter.smoothing),
                  smooth_span = ..(smooth.span),
                  smooth_linetype = ..(smooth.line.type),
                  smooth_color = ..(smooth.line.color),
                  smooth_size = ..(smooth.line.size),
                  log = ..(axis.log.type),
                  guide = ..(plot.scatter.guide),
                  guide_linetype = ..(guide.line.type),
                  guide_alpha = ..(guide.line.alpha),
                  guide_color = ..(guide.line.color),
                  guide_size = ..(guide.line.size),
                  point_shape = ..(point.shape),
                  point_color = ..(point.color),
                  point_alpha = ..(point.alpha),
                  point_size = ..(point.size),
                  point_stroke = 1,
                  line_color = ..(line.color),
                  line_alpha = ..(line.alpha),
                  line_size = ..(line.size),
                  line_linetype = ..(line.type)) #ref line is guide argumenti.e. guide = TRUE
     })
     # IWRES vs TAD ----
   } else if(treeSelected == "IWRES vs TAD") {
       userPlot <-  metaExpr({
          ..(userPlot) %>%
             set_var_types(idv = "TAD") %>%
           res_vs_idv(res = "IWRES",
                      type = ..(plot.scatter.type),
                      facets = c(..(facetObs), ..(selectedFacet)),
                      scales = ..(axis.scale),
                      nrow = ..(arrangeRows),
                      ncol = ..(arrangeCols),
                      page = ..(pageNumber),
                      subtitle =  ..(paste0(ofv, ", Eps shrink: @epsshk")),
                      smooth_method = ..(plot.scatter.smoothing),
                      smooth_span = ..(smooth.span),
                      smooth_linetype = ..(smooth.line.type),
                      smooth_color = ..(smooth.line.color),
                      smooth_size = ..(smooth.line.size),
                      log = ..(axis.log.type),
                      guide = ..(plot.scatter.guide),
                      guide_linetype = ..(guide.line.type),
                      guide_alpha = ..(guide.line.alpha),
                      guide_color = ..(guide.line.color),
                      guide_size = ..(guide.line.size),
                      point_shape = ..(point.shape),
                      point_color = ..(point.color),
                      point_alpha = ..(point.alpha),
                      point_size = ..(point.size),
                      point_stroke = 1,
                      line_color = ..(line.color),
                      line_alpha = ..(line.alpha),
                      line_size = ..(line.size),
                      line_linetype = ..(line.type))
       })
       # IWRES vs IVAR ----
   } else if(treeSelected == "IWRES vs IVAR") {
       userPlot <- metaExpr({
          ..(userPlot) %>%
         res_vs_idv(res = "IWRES",
                    type = ..(plot.scatter.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    subtitle =  ..(paste0(ofv, ", Eps shrink: @epsshk")),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
       })
       # NPD vs PRED ----
   } else if(treeSelected == "NPD vs PRED"){
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "NPD" ) %>%
         res_vs_pred(res = "NPD",
                     type = ..(plot.scatter.type),
                     facets = c(..(facetObs), ..(selectedFacet)),
                     scales = ..(axis.scale),
                     nrow = ..(arrangeRows),
                     ncol = ..(arrangeCols),
                     page = ..(pageNumber),
                     subtitle = ..(ofv),
                     smooth_method = ..(plot.scatter.smoothing),
                     smooth_span = ..(smooth.span),
                     smooth_linetype = ..(smooth.line.type),
                     smooth_color = ..(smooth.line.color),
                     smooth_size = ..(smooth.line.size),
                     log = ..(axis.log.type),
                     guide = ..(plot.scatter.guide),
                     guide_linetype = ..(guide.line.type),
                     guide_alpha = ..(guide.line.alpha),
                     guide_color = ..(guide.line.color),
                     guide_size = ..(guide.line.size),
                     point_shape = ..(point.shape),
                     point_color = ..(point.color),
                     point_alpha = ..(point.alpha),
                     point_size = ..(point.size),
                     point_stroke = 1,
                     line_color = ..(line.color),
                     line_alpha = ..(line.alpha),
                     line_size = ..(line.size),
                     line_linetype = ..(line.type)) #ref line is guide argumenti.e. guide = TRUE
     })
     # NPD vs PPRED ----
   } else if(treeSelected == "NPD vs PPRED"){
     userPlot <- metaExpr({
       ..(userPlot) %>%
         set_var_types(res = "NPD", pred = "PPRED") %>%
         res_vs_pred(res = "NPD",
                     type = ..(plot.scatter.type),
                     facets = c(..(facetObs), ..(selectedFacet)),
                     scales = ..(axis.scale),
                     nrow = ..(arrangeRows),
                     ncol = ..(arrangeCols),
                     page = ..(pageNumber),
                     subtitle = ..(ofv),
                     smooth_method = ..(plot.scatter.smoothing),
                     smooth_span = ..(smooth.span),
                     smooth_linetype = ..(smooth.line.type),
                     smooth_color = ..(smooth.line.color),
                     smooth_size = ..(smooth.line.size),
                     log = ..(axis.log.type),
                     guide = ..(plot.scatter.guide),
                     guide_linetype = ..(guide.line.type),
                     guide_alpha = ..(guide.line.alpha),
                     guide_color = ..(guide.line.color),
                     guide_size = ..(guide.line.size),
                     point_shape = ..(point.shape),
                     point_color = ..(point.color),
                     point_alpha = ..(point.alpha),
                     point_size = ..(point.size),
                     point_stroke = 1,
                     line_color = ..(line.color),
                     line_alpha = ..(line.alpha),
                     line_size = ..(line.size),
                     line_linetype = ..(line.type)) #ref line is guide argumenti.e. guide = TRUE
     })
     # NPD vs TAD ----
   } else if(treeSelected == "NPD vs TAD") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(idv = "TAD", res = "NPD") %>%
         res_vs_idv(res = "NPD",
                    type = ..(plot.scatter.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    subtitle = ..(ofv),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
     # NPD vs IVAR ----
   } else if(treeSelected == "NPD vs IVAR") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "NPD") %>%
         res_vs_idv(res = "NPD",
                    type = ..(plot.scatter.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    subtitle = ..(ofv),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
     # NPDE vs PRED ----
   } else if(treeSelected == "NPDE vs PRED"){
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "NPDE" ) %>%
         res_vs_pred(res = "NPDE",
                     type = ..(plot.scatter.type),
                     facets = c(..(facetObs), ..(selectedFacet)),
                     scales = ..(axis.scale),
                     nrow = ..(arrangeRows),
                     ncol = ..(arrangeCols),
                     page = ..(pageNumber),
                     subtitle = ..(ofv),
                     smooth_method = ..(plot.scatter.smoothing),
                     smooth_span = ..(smooth.span),
                     smooth_linetype = ..(smooth.line.type),
                     smooth_color = ..(smooth.line.color),
                     smooth_size = ..(smooth.line.size),
                     log = ..(axis.log.type),
                     guide = ..(plot.scatter.guide),
                     guide_linetype = ..(guide.line.type),
                     guide_alpha = ..(guide.line.alpha),
                     guide_color = ..(guide.line.color),
                     guide_size = ..(guide.line.size),
                     point_shape = ..(point.shape),
                     point_color = ..(point.color),
                     point_alpha = ..(point.alpha),
                     point_size = ..(point.size),
                     point_stroke = 1,
                     line_color = ..(line.color),
                     line_alpha = ..(line.alpha),
                     line_size = ..(line.size),
                     line_linetype = ..(line.type)) #ref line is guide argumenti.e. guide = TRUE
     })
     # NPDE vs PPRED ----
   } else if(treeSelected == "NPDE vs PPRED"){
     userPlot <- metaExpr({
       ..(userPlot) %>%
         set_var_types(res = "NPDE", pred = "PPRED") %>%
         res_vs_pred(res = "NPDE",
                     type = ..(plot.scatter.type),
                     facets = c(..(facetObs), ..(selectedFacet)),
                     scales = ..(axis.scale),
                     nrow = ..(arrangeRows),
                     ncol = ..(arrangeCols),
                     page = ..(pageNumber),
                     subtitle = ..(ofv),
                     smooth_method = ..(plot.scatter.smoothing),
                     smooth_span = ..(smooth.span),
                     smooth_linetype = ..(smooth.line.type),
                     smooth_color = ..(smooth.line.color),
                     smooth_size = ..(smooth.line.size),
                     log = ..(axis.log.type),
                     guide = ..(plot.scatter.guide),
                     guide_linetype = ..(guide.line.type),
                     guide_alpha = ..(guide.line.alpha),
                     guide_color = ..(guide.line.color),
                     guide_size = ..(guide.line.size),
                     point_shape = ..(point.shape),
                     point_color = ..(point.color),
                     point_alpha = ..(point.alpha),
                     point_size = ..(point.size),
                     point_stroke = 1,
                     line_color = ..(line.color),
                     line_alpha = ..(line.alpha),
                     line_size = ..(line.size),
                     line_linetype = ..(line.type)) #ref line is guide argumenti.e. guide = TRUE
     })
     # NPDE vs TAD ----
   } else if(treeSelected == "NPDE vs TAD") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(idv = "TAD", res = "NPDE") %>%
         res_vs_idv(res = "NPDE",
                    type = ..(plot.scatter.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    subtitle = ..(ofv),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
     # NPD vs IVAR ----
   } else if(treeSelected == "NPDE vs IVAR") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "NPDE") %>%
         res_vs_idv(res = "NPDE",
                    type = ..(plot.scatter.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    subtitle = ..(ofv),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
       # PCWRES vs PRED ----
   } else if(treeSelected == "PCWRES vs PRED"){
     userPlot <- metaExpr({
        ..(userPlot) %>%
       res_vs_pred(res = "PCWRES",
                   type = ..(plot.scatter.type),
                   facets = c(..(facetObs), ..(selectedFacet)),
                   scales = ..(axis.scale),
                   nrow = ..(arrangeRows),
                   ncol = ..(arrangeCols),
                   page = ..(pageNumber),
                   subtitle = ..(ofv),
                   smooth_method = ..(plot.scatter.smoothing),
                   smooth_span = ..(smooth.span),
                   smooth_linetype = ..(smooth.line.type),
                   smooth_color = ..(smooth.line.color),
                   smooth_size = ..(smooth.line.size),
                   log = ..(axis.log.type),
                   guide = ..(plot.scatter.guide),
                   guide_linetype = ..(guide.line.type),
                   guide_alpha = ..(guide.line.alpha),
                   guide_color = ..(guide.line.color),
                   guide_size = ..(guide.line.size),
                   point_shape = ..(point.shape),
                   point_color = ..(point.color),
                   point_alpha = ..(point.alpha),
                   point_size = ..(point.size),
                   point_stroke = 1,
                   line_color = ..(line.color),
                   line_alpha = ..(line.alpha),
                   line_size = ..(line.size),
                   line_linetype = ..(line.type)) #ref line is guide argumenti.e. guide = TRUE
     })
     # PCWRES vs PPRED ----
   } else if(treeSelected == "PCWRES vs PPRED"){
     userPlot <- metaExpr({
       ..(userPlot) %>%
         set_var_types(pred = "PPRED") %>%
         res_vs_pred(res = "PCWRES",
                     type = ..(plot.scatter.type),
                     facets = c(..(facetObs), ..(selectedFacet)),
                     scales = ..(axis.scale),
                     nrow = ..(arrangeRows),
                     ncol = ..(arrangeCols),
                     page = ..(pageNumber),
                     subtitle = ..(ofv),
                     smooth_method = ..(plot.scatter.smoothing),
                     smooth_span = ..(smooth.span),
                     smooth_linetype = ..(smooth.line.type),
                     smooth_color = ..(smooth.line.color),
                     smooth_size = ..(smooth.line.size),
                     log = ..(axis.log.type),
                     guide = ..(plot.scatter.guide),
                     guide_linetype = ..(guide.line.type),
                     guide_alpha = ..(guide.line.alpha),
                     guide_color = ..(guide.line.color),
                     guide_size = ..(guide.line.size),
                     point_shape = ..(point.shape),
                     point_color = ..(point.color),
                     point_alpha = ..(point.alpha),
                     point_size = ..(point.size),
                     point_stroke = 1,
                     line_color = ..(line.color),
                     line_alpha = ..(line.alpha),
                     line_size = ..(line.size),
                     line_linetype = ..(line.type)) #ref line is guide argumenti.e. guide = TRUE
     })
     # PCWRES vs TAD ----
   } else if(treeSelected == "PCWRES vs TAD") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(idv = "TAD") %>%
         res_vs_idv(res = "PCWRES",
                    type = ..(plot.scatter.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    subtitle = ..(ofv),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
     # PCWRES vs IVAR ----
   } else if(treeSelected == "PCWRES vs IVAR") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
       res_vs_idv(res = "PCWRES",
                  type = ..(plot.scatter.type),
                  facets = c(..(facetObs), ..(selectedFacet)),
                  scales = ..(axis.scale),
                  nrow = ..(arrangeRows),
                  ncol = ..(arrangeCols),
                  page = ..(pageNumber),
                  subtitle = ..(ofv),
                  smooth_method = ..(plot.scatter.smoothing),
                  smooth_span = ..(smooth.span),
                  smooth_linetype = ..(smooth.line.type),
                  smooth_color = ..(smooth.line.color),
                  smooth_size = ..(smooth.line.size),
                  log = ..(axis.log.type),
                  guide = ..(plot.scatter.guide),
                  guide_linetype = ..(guide.line.type),
                  guide_alpha = ..(guide.line.alpha),
                  guide_color = ..(guide.line.color),
                  guide_size = ..(guide.line.size),
                  point_shape = ..(point.shape),
                  point_color = ..(point.color),
                  point_alpha = ..(point.alpha),
                  point_size = ..(point.size),
                  point_stroke = 1,
                  line_color = ..(line.color),
                  line_alpha = ..(line.alpha),
                  line_size = ..(line.size),
                  line_linetype = ..(line.type))
     })
# WRES vs PRED ----
   } else if(treeSelected == "WRES vs PRED"){
     userPlot <- metaExpr({
        ..(userPlot) %>%
         res_vs_pred(res = "WRES",
                     type = ..(plot.scatter.type),
                     facets = c(..(facetObs), ..(selectedFacet)),
                     scales = ..(axis.scale),
                     nrow = ..(arrangeRows),
                     ncol = ..(arrangeCols),
                     page = ..(pageNumber),
                     subtitle = ..(ofv),
                     smooth_method = ..(plot.scatter.smoothing),
                     smooth_span = ..(smooth.span),
                     smooth_linetype = ..(smooth.line.type),
                     smooth_color = ..(smooth.line.color),
                     smooth_size = ..(smooth.line.size),
                     log = ..(axis.log.type),
                     guide = ..(plot.scatter.guide),
                     guide_linetype = ..(guide.line.type),
                     guide_alpha = ..(guide.line.alpha),
                     guide_color = ..(guide.line.color),
                     guide_size = ..(guide.line.size),
                     point_shape = ..(point.shape),
                     point_color = ..(point.color),
                     point_alpha = ..(point.alpha),
                     point_size = ..(point.size),
                     point_stroke = 1,
                     line_color = ..(line.color),
                     line_alpha = ..(line.alpha),
                     line_size = ..(line.size),
                     line_linetype = ..(line.type))
     })
# WRES vs TAD ----
   } else if(treeSelected == "WRES vs TAD") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(idv = "TAD") %>%
         res_vs_idv(res = "WRES",
                    type = ..(plot.scatter.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    subtitle = ..(ofv),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
# WRES vs IVAR ----
   } else if(treeSelected == "WRES vs IVAR") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
       res_vs_idv(res = "WRES",
                  type = ..(plot.scatter.type),
                  facets = c(..(facetObs), ..(selectedFacet)),
                  scales = ..(axis.scale),
                  nrow = ..(arrangeRows),
                  ncol = ..(arrangeCols),
                  page = ..(pageNumber),
                  subtitle = ..(ofv),
                  smooth_method = ..(plot.scatter.smoothing),
                  smooth_span = ..(smooth.span),
                  smooth_linetype = ..(smooth.line.type),
                  smooth_color = ..(smooth.line.color),
                  smooth_size = ..(smooth.line.size),
                  log = ..(axis.log.type),
                  guide = ..(plot.scatter.guide),
                  guide_linetype = ..(guide.line.type),
                  guide_alpha = ..(guide.line.alpha),
                  guide_color = ..(guide.line.color),
                  guide_size = ..(guide.line.size),
                  point_shape = ..(point.shape),
                  point_color = ..(point.color),
                  point_alpha = ..(point.alpha),
                  point_size = ..(point.size),
                  point_stroke = 1,
                  line_color = ..(line.color),
                  line_alpha = ..(line.alpha),
                  line_size = ..(line.size),
                  line_linetype = ..(line.type))
     })
#--------------------Covariate Models-------------------------#
   } else if(treeSelected == "CWRES vs Covariate") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
        res_vs_cov(covariate = ..(selectedCovariate),
                   type = ..(covPlotType),
                   res = "CWRES",
                   facets = c(..(facetObs), ..(selectedFacet)),
                   scales = ..(axis.scale),
                   nrow = ..(arrangeRows),
                   ncol = ..(arrangeCols),
                   page = ..(pageNumber),
                   guide = ..(plot.scatter.guide),
                   guide_linetype = ..(guide.line.type),
                   guide_alpha = ..(guide.line.alpha),
                   guide_color = ..(guide.line.color),
                   guide_size = ..(guide.line.size),
                   guide_intercept = 0,
                   guide_slope = 0,
                   boxplot_alpha = ..(boxplot.alpha),
                   boxplot_fill = ..(boxplot.fill.color),
                   boxplot_color = ..(boxplot.line.color),
                   boxplot_outlier.color = ..(outlier.color),
                   boxplot_outlier.shape = ..(outlier.shape),
                   boxplot_outlier.size = ..(outlier.size),
                   boxplot_outlier.alpha = ..(outlier.alpha),
                   smooth_method = ..(plot.scatter.smoothing),
                   smooth_span = ..(smooth.span),
                   smooth_linetype = ..(smooth.line.type),
                   smooth_color = ..(smooth.line.color),
                   smooth_size = ..(smooth.line.size),
                   log = ..(axis.log.type),
                   point_shape = ..(point.shape),
                   point_color = ..(point.color),
                   point_alpha = ..(point.alpha),
                   point_size = ..(point.size),
                   point_stroke = 1,
                   line_color = ..(line.color),
                   line_alpha = ..(line.alpha),
                   line_size = ..(line.size),
                   line_linetype = ..(line.type))
     })

    # ECWRES vs Covariate ----
   } else if(treeSelected == "ECWRES vs Covariate") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "ECWRES") %>%
         res_vs_cov(covariate = ..(selectedCovariate),
                  type = ..(covPlotType),
                  res = "ECWRES",
                  facets = c(..(facetObs), ..(selectedFacet)),
                  scales = ..(axis.scale),
                  nrow = ..(arrangeRows),
                  ncol = ..(arrangeCols),
                  page = ..(pageNumber),
                  guide = ..(plot.scatter.guide),
                  guide_linetype = ..(guide.line.type),
                  guide_alpha = ..(guide.line.alpha),
                  guide_color = ..(guide.line.color),
                  guide_size = ..(guide.line.size),
                  guide_intercept = 0,
                  guide_slope = 0,
                  boxplot_alpha = ..(boxplot.alpha),
                  boxplot_fill = ..(boxplot.fill.color),
                  boxplot_color = ..(boxplot.line.color),
                  boxplot_outlier.color = ..(outlier.color),
                  boxplot_outlier.shape = ..(outlier.shape),
                  boxplot_outlier.size = ..(outlier.size),
                  boxplot_outlier.alpha = ..(outlier.alpha),
                  smooth_method = ..(plot.scatter.smoothing),
                  smooth_span = ..(smooth.span),
                  smooth_linetype = ..(smooth.line.type),
                  smooth_color = ..(smooth.line.color),
                  smooth_size = ..(smooth.line.size),
                  log = ..(axis.log.type),
                  point_shape = ..(point.shape),
                  point_color = ..(point.color),
                  point_alpha = ..(point.alpha),
                  point_size = ..(point.size),
                  point_stroke = 1,
                  line_color = ..(line.color),
                  line_alpha = ..(line.alpha),
                  line_size = ..(line.size),
                  line_linetype = ..(line.type))
     })
     # EWRES vs Covariate ----
   } else if(treeSelected == "EWRES vs Covariate") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "EWRES") %>%
         res_vs_cov(covariate = ..(selectedCovariate),
                    type = ..(covPlotType),
                    res = "EWRES",
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    guide_intercept = 0,
                    guide_slope = 0,
                    boxplot_alpha = ..(boxplot.alpha),
                    boxplot_fill = ..(boxplot.fill.color),
                    boxplot_color = ..(boxplot.line.color),
                    boxplot_outlier.color = ..(outlier.color),
                    boxplot_outlier.shape = ..(outlier.shape),
                    boxplot_outlier.size = ..(outlier.size),
                    boxplot_outlier.alpha = ..(outlier.alpha),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
     # NPD vs Covariate ----
   } else if(treeSelected == "NPD vs Covariate") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "NPD") %>%
         res_vs_cov(covariate = ..(selectedCovariate),
                    type = ..(covPlotType),
                    res = "NPD",
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    guide_intercept = 0,
                    guide_slope = 0,
                    boxplot_alpha = ..(boxplot.alpha),
                    boxplot_fill = ..(boxplot.fill.color),
                    boxplot_color = ..(boxplot.line.color),
                    boxplot_outlier.color = ..(outlier.color),
                    boxplot_outlier.shape = ..(outlier.shape),
                    boxplot_outlier.size = ..(outlier.size),
                    boxplot_outlier.alpha = ..(outlier.alpha),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
     # NPDE vs Covariate ----
   } else if(treeSelected == "NPDE vs Covariate") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
           set_var_types(res = "NPDE") %>%
         res_vs_cov(covariate = ..(selectedCovariate),
                    type = ..(covPlotType),
                    res = "NPDE",
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    guide_intercept = 0,
                    guide_slope = 0,
                    boxplot_alpha = ..(boxplot.alpha),
                    boxplot_fill = ..(boxplot.fill.color),
                    boxplot_color = ..(boxplot.line.color),
                    boxplot_outlier.color = ..(outlier.color),
                    boxplot_outlier.shape = ..(outlier.shape),
                    boxplot_outlier.size = ..(outlier.size),
                    boxplot_outlier.alpha = ..(outlier.alpha),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
     })
# Covariate Plots ----
   } else if(treeSelected == "ETA vs Covariate") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
     eta_vs_cov(covariate = ..(selectedCovariate),
                type = ..(covPlotType),
                facets = c("variable", ..(selectedFacet)),
                scales = ..(axis.scale),
                nrow = ..(arrangeRows),
                ncol = ..(arrangeCols),
                page = ..(pageNumber),
                guide = ..(plot.scatter.guide),
                guide_linetype = ..(guide.line.type),
                guide_alpha = ..(guide.line.alpha),
                guide_color = ..(guide.line.color),
                guide_size = ..(guide.line.size),
                guide_intercept = 0,
                guide_slope = 0,
                boxplot_alpha = ..(boxplot.alpha),
                boxplot_fill = ..(boxplot.fill.color),
                boxplot_color = ..(boxplot.line.color),
                boxplot_outlier.color = ..(outlier.color),
                boxplot_outlier.shape = ..(outlier.shape),
                boxplot_outlier.size = ..(outlier.size),
                boxplot_outlier.alpha = ..(outlier.alpha),
                smooth_method = ..(plot.scatter.smoothing),
                smooth_span = ..(smooth.span),
                smooth_linetype = ..(smooth.line.type),
                smooth_color = ..(smooth.line.color),
                smooth_size = ..(smooth.line.size),
                log = ..(axis.log.type),
                point_shape = ..(point.shape),
                point_color = ..(point.color),
                point_alpha = ..(point.alpha),
                point_size = ..(point.size),
                point_stroke = 1,
                line_color = ..(line.color),
                line_alpha = ..(line.alpha),
                line_size = ..(line.size),
                line_linetype = ..(line.type))
     })
   } else if(treeSelected == "IWRES vs Covariate") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
       res_vs_cov(covariate = ..(selectedCovariate),
                  type = ..(covPlotType),
                  res = "IWRES",
                  facets = c(..(facetObs), ..(selectedFacet)),
                  scales = ..(axis.scale),
                  nrow = ..(arrangeRows),
                  ncol = ..(arrangeCols),
                  page = ..(pageNumber),
                  guide = ..(plot.scatter.guide),
                  guide_linetype = ..(guide.line.type),
                  guide_alpha = ..(guide.line.alpha),
                  guide_color = ..(guide.line.color),
                  guide_size = ..(guide.line.size),
                  guide_intercept = 0,
                  guide_slope = 0,
                  boxplot_alpha = ..(boxplot.alpha),
                  boxplot_fill = ..(boxplot.fill.color),
                  boxplot_color = ..(boxplot.line.color),
                  boxplot_outlier.color = ..(outlier.color),
                  boxplot_outlier.shape = ..(outlier.shape),
                  boxplot_outlier.size = ..(outlier.size),
                  boxplot_outlier.alpha = ..(outlier.alpha),
                  smooth_method = ..(plot.scatter.smoothing),
                  smooth_span = ..(smooth.span),
                  smooth_linetype = ..(smooth.line.type),
                  smooth_color = ..(smooth.line.color),
                  smooth_size = ..(smooth.line.size),
                  log = ..(axis.log.type),
                  point_shape = ..(point.shape),
                  point_color = ..(point.color),
                  point_alpha = ..(point.alpha),
                  point_size = ..(point.size),
                  point_stroke = 1,
                  line_color = ..(line.color),
                  line_alpha = ..(line.alpha),
                  line_size = ..(line.size),
                  line_linetype = ..(line.type))
     })
   } else if(treeSelected == "WRES vs Covariate") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
       res_vs_cov(covariate = ..(selectedCovariate),
                  type = ..(covPlotType),
                  res = "WRES",
                  facets = c(..(facetObs), ..(selectedFacet)),
                  scales = ..(axis.scale),
                  nrow = ..(arrangeRows),
                  ncol = ..(arrangeCols),
                  page = ..(pageNumber),
                  guide = ..(plot.scatter.guide),
                  guide_linetype = ..(guide.line.type),
                  guide_alpha = ..(guide.line.alpha),
                  guide_color = ..(guide.line.color),
                  guide_size = ..(guide.line.size),
                  guide_intercept = 0,
                  guide_slope = 0,
                  boxplot_alpha = ..(boxplot.alpha),
                  boxplot_fill = ..(boxplot.fill.color),
                  boxplot_color = ..(boxplot.line.color),
                  boxplot_outlier.color = ..(outlier.color),
                  boxplot_outlier.shape = ..(outlier.shape),
                  boxplot_outlier.size = ..(outlier.size),
                  boxplot_outlier.alpha = ..(outlier.alpha),
                  smooth_method = ..(plot.scatter.smoothing),
                  smooth_span = ..(smooth.span),
                  smooth_linetype = ..(smooth.line.type),
                  smooth_color = ..(smooth.line.color),
                  smooth_size = ..(smooth.line.size),
                  log = ..(axis.log.type),
                  point_shape = ..(point.shape),
                  point_color = ..(point.color),
                  point_alpha = ..(point.alpha),
                  point_size = ..(point.size),
                  point_stroke = 1,
                  line_color = ..(line.color),
                  line_alpha = ..(line.alpha),
                  line_size = ..(line.size),
                  line_linetype = ..(line.type))
     })
   } else if(treeSelected == "Structural Parameter vs Covariate") {
     userPlot <- metaExpr({
        ..(userPlot) %>%
       prm_vs_cov(covariate = ..(selectedCovariate),
                  type = ..(covPlotType),
                  facets = c("variable", ..(selectedFacet)),
                  scales = ..(axis.scale),
                  nrow = ..(arrangeRows),
                  ncol = ..(arrangeCols),
                  page = ..(pageNumber),
                  guide = ..(plot.scatter.guide),
                  guide_linetype = ..(guide.line.type),
                  guide_alpha = ..(guide.line.alpha),
                  guide_color = ..(guide.line.color),
                  guide_size = ..(guide.line.size),
                  guide_intercept = 0,
                  guide_slope = 0,
                  boxplot_alpha = ..(boxplot.alpha),
                  boxplot_fill = ..(boxplot.fill.color),
                  boxplot_color = ..(boxplot.line.color),
                  boxplot_outlier.color = ..(outlier.color),
                  boxplot_outlier.shape = ..(outlier.shape),
                  boxplot_outlier.size = ..(outlier.size),
                  boxplot_outlier.alpha = ..(outlier.alpha),
                  smooth_method = ..(plot.scatter.smoothing),
                  smooth_span = ..(smooth.span),
                  smooth_linetype = ..(smooth.line.type),
                  smooth_color = ..(smooth.line.color),
                  smooth_size = ..(smooth.line.size),
                  log = ..(axis.log.type),
                  point_shape = ..(point.shape),
                  point_color = ..(point.color),
                  point_alpha = ..(point.alpha),
                  point_size = ..(point.size),
                  point_stroke = 1,
                  line_color = ..(line.color),
                  line_alpha = ..(line.alpha),
                  line_size = ..(line.size),
                  line_linetype = ..(line.type))
     })
   } else if(treeSelected == "PCWRES vs Covariate") {
      userPlot <- metaExpr({
         ..(userPlot) %>%
         res_vs_cov(covariate = ..(selectedCovariate),
                    type = ..(covPlotType),
                    res = "PCWRES",
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    guide = ..(plot.scatter.guide),
                    guide_linetype = ..(guide.line.type),
                    guide_alpha = ..(guide.line.alpha),
                    guide_color = ..(guide.line.color),
                    guide_size = ..(guide.line.size),
                    guide_intercept = 0,
                    guide_slope = 0,
                    boxplot_alpha = ..(boxplot.alpha),
                    boxplot_fill = ..(boxplot.fill.color),
                    boxplot_color = ..(boxplot.line.color),
                    boxplot_outlier.color = ..(outlier.color),
                    boxplot_outlier.shape = ..(outlier.shape),
                    boxplot_outlier.size = ..(outlier.size),
                    boxplot_outlier.alpha = ..(outlier.alpha),
                    smooth_method = ..(plot.scatter.smoothing),
                    smooth_span = ..(smooth.span),
                    smooth_linetype = ..(smooth.line.type),
                    smooth_color = ..(smooth.line.color),
                    smooth_size = ..(smooth.line.size),
                    log = ..(axis.log.type),
                    point_shape = ..(point.shape),
                    point_color = ..(point.color),
                    point_alpha = ..(point.alpha),
                    point_size = ..(point.size),
                    point_stroke = 1,
                    line_color = ..(line.color),
                    line_alpha = ..(line.alpha),
                    line_size = ..(line.size),
                    line_linetype = ..(line.type))
      })

############### DISTRIBUTION PLOTS ##########################
     # Covariates Distribution ----
  } else if(treeSelected == "Covariate Distribution") { #Requires continuous covariates
    userPlot <- metaExpr({
       ..(userPlot) %>%
      cov_distrib(type = ..(plot.distribution.type),
                  log = ..(axis.log.type),
                  scales = ..(axis.scale),
                  nrow = ..(arrangeRows),
                  ncol = ..(arrangeCols),
                  page = ..(pageNumber),
                  histogram_bins = ..(hist.nbins),
                  histogram_fill = ..(hist.fill.color),
                  histogram_alpha = ..(hist.alpha),
                  histogram_color = ..(hist.line.color),
                  histogram_linetype = ..(hist.line.type),
                  histogram_size = ..(hist.size),
                  rug_sides = ..(rug.sides),
                  rug_size = ..(rug.line.size),
                  rug_color = ..(rug.color),
                  density_fill = ..(density.fill.color),
                  density_alpha = ..(density.alpha),
                  density_color = ..(density.line.color),
                  density_linetype = ..(density.line.type),
                  density_size = ..(density.size))
    })
  } else if(treeSelected == "CWRES Distribution") {
      userPlot <- metaExpr({
         ..(userPlot) %>%
        res_distrib(res = "CWRES",
                    type = ..(plot.distribution.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    log = ..(axis.log.type),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    histogram_bins = ..(hist.nbins),
                    histogram_fill = ..(hist.fill.color),
                    histogram_alpha = ..(hist.alpha),
                    histogram_color = ..(hist.line.color),
                    histogram_linetype = ..(hist.line.type),
                    histogram_size = ..(hist.size),
                    rug_sides = ..(rug.sides),
                    rug_size = ..(rug.line.size),
                    rug_color = ..(rug.color),
                    density_fill = ..(density.fill.color),
                    density_alpha = ..(density.alpha),
                    density_color = ..(density.line.color),
                    density_linetype = ..(density.line.type),
                    density_size = ..(density.size))
      })
  # ECWRES Distribution ---
  } else if(treeSelected == "ECWRES Distribution") {
    userPlot <- metaExpr({
       ..(userPlot) %>%
          set_var_types(res = "ECWRES") %>%
        res_distrib(res = "ECWRES",
                  type = ..(plot.distribution.type),
                  facets = c(..(facetObs), ..(selectedFacet)),
                  scales = ..(axis.scale),
                  nrow = ..(arrangeRows),
                  ncol = ..(arrangeCols),
                  page = ..(pageNumber),
                  log = ..(axis.log.type),
                  histogram_bins = ..(hist.nbins),
                  histogram_fill = ..(hist.fill.color),
                  histogram_alpha = ..(hist.alpha),
                  histogram_color = ..(hist.line.color),
                  histogram_linetype = ..(hist.line.type),
                  histogram_size = ..(hist.size),
                  rug_sides = ..(rug.sides),
                  rug_size = ..(rug.line.size),
                  rug_color = ..(rug.color),
                  density_fill = ..(density.fill.color),
                  density_alpha = ..(density.alpha),
                  density_color = ..(density.line.color),
                  density_linetype = ..(density.line.type),
                  density_size = ..(density.size))
    })
    # EWRES Distribution ---
  } else if(treeSelected == "EWRES Distribution") {
    userPlot <- metaExpr({
       ..(userPlot) %>%
          set_var_types(res = "EWRES") %>%
        res_distrib(res = "EWRES",
                    type = ..(plot.distribution.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    log = ..(axis.log.type),
                    histogram_bins = ..(hist.nbins),
                    histogram_fill = ..(hist.fill.color),
                    histogram_alpha = ..(hist.alpha),
                    histogram_color = ..(hist.line.color),
                    histogram_linetype = ..(hist.line.type),
                    histogram_size = ..(hist.size),
                    rug_sides = ..(rug.sides),
                    rug_size = ..(rug.line.size),
                    rug_color = ..(rug.color),
                    density_fill = ..(density.fill.color),
                    density_alpha = ..(density.alpha),
                    density_color = ..(density.line.color),
                    density_linetype = ..(density.line.type),
                    density_size = ..(density.size))
    })
  } else if(treeSelected == "ETA Distribution") {
      userPlot <- metaExpr({
         ..(userPlot) %>%
        eta_distrib(type = ..(plot.distribution.type),
                    log = ..(axis.log.type),
                    facets = c("variable", ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    histogram_bins = ..(hist.nbins),
                    histogram_fill = ..(hist.fill.color),
                    histogram_alpha = ..(hist.alpha),
                    histogram_color = ..(hist.line.color),
                    histogram_linetype = ..(hist.line.type),
                    histogram_size = ..(hist.size),
                    rug_sides = ..(rug.sides),
                    rug_size = ..(rug.line.size),
                    rug_color = ..(rug.color),
                    density_fill = ..(density.fill.color),
                    density_alpha = ..(density.alpha),
                    density_color = ..(density.line.color),
                    density_linetype = ..(density.line.type),
                    density_size = ..(density.size))
      })
  } else if(treeSelected == "IWRES Distribution") {
      userPlot <- metaExpr({
         ..(userPlot) %>%
        res_distrib(res = "IWRES",
                    type = ..(plot.distribution.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    log = ..(axis.log.type),
                    histogram_bins = ..(hist.nbins),
                    histogram_fill = ..(hist.fill.color),
                    histogram_alpha = ..(hist.alpha),
                    histogram_color = ..(hist.line.color),
                    histogram_linetype = ..(hist.line.type),
                    histogram_size = ..(hist.size),
                    rug_sides = ..(rug.sides),
                    rug_size = ..(rug.line.size),
                    rug_color = ..(rug.color),
                    density_fill = ..(density.fill.color),
                    density_alpha = ..(density.alpha),
                    density_color = ..(density.line.color),
                    density_linetype = ..(density.line.type),
                    density_size = ..(density.size))
      })
      # NPD Distribution ---
  } else if(treeSelected == "NPD Distribution") {
    userPlot <- metaExpr({
       ..(userPlot) %>%
          set_var_types(res = "NPD") %>%
        res_distrib(res = "NPD",
                    type = ..(plot.distribution.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    log = ..(axis.log.type),
                    histogram_bins = ..(hist.nbins),
                    histogram_fill = ..(hist.fill.color),
                    histogram_alpha = ..(hist.alpha),
                    histogram_color = ..(hist.line.color),
                    histogram_linetype = ..(hist.line.type),
                    histogram_size = ..(hist.size),
                    rug_sides = ..(rug.sides),
                    rug_size = ..(rug.line.size),
                    rug_color = ..(rug.color),
                    density_fill = ..(density.fill.color),
                    density_alpha = ..(density.alpha),
                    density_color = ..(density.line.color),
                    density_linetype = ..(density.line.type),
                    density_size = ..(density.size))
    })
    # NPDE Distribution ---
  } else if(treeSelected == "NPDE Distribution") {
    userPlot <- metaExpr({
       ..(userPlot) %>%
          set_var_types(res = "NPDE") %>%
        res_distrib(res = "NPDE",
                    type = ..(plot.distribution.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    log = ..(axis.log.type),
                    histogram_bins = ..(hist.nbins),
                    histogram_fill = ..(hist.fill.color),
                    histogram_alpha = ..(hist.alpha),
                    histogram_color = ..(hist.line.color),
                    histogram_linetype = ..(hist.line.type),
                    histogram_size = ..(hist.size),
                    rug_sides = ..(rug.sides),
                    rug_size = ..(rug.line.size),
                    rug_color = ..(rug.color),
                    density_fill = ..(density.fill.color),
                    density_alpha = ..(density.alpha),
                    density_color = ..(density.line.color),
                    density_linetype = ..(density.line.type),
                    density_size = ..(density.size))
    })
  } else if(treeSelected == "Structural Parameter Distribution") {
      userPlot <- metaExpr({
         ..(userPlot) %>%
        prm_distrib(type = ..(plot.distribution.type),
                    log = ..(axis.log.type),
                    facets = c("variable",..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    histogram_bins = ..(hist.nbins),
                    histogram_fill = ..(hist.fill.color),
                    histogram_alpha = ..(hist.alpha),
                    histogram_color = ..(hist.line.color),
                    histogram_linetype = ..(hist.line.type),
                    histogram_size = ..(hist.size),
                    rug_sides = ..(rug.sides),
                    rug_size = ..(rug.line.size),
                    rug_color = ..(rug.color),
                    density_fill = ..(density.fill.color),
                    density_alpha = ..(density.alpha),
                    density_color = ..(density.line.color),
                    density_linetype = ..(density.line.type),
                    density_size = ..(density.size))
      })
  # PCWRES Distribution ----
  } else if(treeSelected == "PCWRES Distribution") {
    userPlot <- metaExpr({
       ..(userPlot) %>%
      res_distrib(res = "PCWRES",
                  type = ..(plot.distribution.type),
                  facets = c(..(facetObs), ..(selectedFacet)),
                  scales = ..(axis.scale),
                  nrow = ..(arrangeRows),
                  ncol = ..(arrangeCols),
                  page = ..(pageNumber),
                  log = ..(axis.log.type),
                  histogram_bins = ..(hist.nbins),
                  histogram_fill = ..(hist.fill.color),
                  histogram_alpha = ..(hist.alpha),
                  histogram_color = ..(hist.line.color),
                  histogram_linetype = ..(hist.line.type),
                  histogram_size = ..(hist.size),
                  rug_sides = ..(rug.sides),
                  rug_size = ..(rug.line.size),
                  rug_color = ..(rug.color),
                  density_fill = ..(density.fill.color),
                  density_alpha = ..(density.alpha),
                  density_color = ..(density.line.color),
                  density_linetype = ..(density.line.type),
                  density_size = ..(density.size))
    })
  } else if(treeSelected == "WRES Distribution") {
      userPlot <- metaExpr({
         ..(userPlot) %>%
        res_distrib(res = "WRES",
                    type = ..(plot.distribution.type),
                    facets = c(..(facetObs), ..(selectedFacet)),
                    scales = ..(axis.scale),
                    nrow = ..(arrangeRows),
                    ncol = ..(arrangeCols),
                    page = ..(pageNumber),
                    log = ..(axis.log.type),
                    histogram_bins = ..(hist.nbins),
                    histogram_fill = ..(hist.fill.color),
                    histogram_alpha = ..(hist.alpha),
                    histogram_color = ..(hist.line.color),
                    histogram_linetype = ..(hist.line.type),
                    histogram_size = ..(hist.size),
                    rug_sides = ..(rug.sides),
                    rug_size = ..(rug.line.size),
                    rug_color = ..(rug.color),
                    density_fill = ..(density.fill.color),
                    density_alpha = ..(density.alpha),
                    density_color = ..(density.line.color),
                    density_linetype = ..(density.line.type),
                    density_size = ..(density.size))
      })

#---------------- QQ Plots----------------#

      # Covariates QQ ----
  } else if(treeSelected == "Covariate QQ") { # Requires Continuous Covariates
      userPlot <- metaExpr({
         ..(userPlot) %>%
        cov_qq(nrow = ..(arrangeRows),
               ncol = ..(arrangeCols),
               page = ..(pageNumber),
               log = ..(axis.log.type),
               scales = ..(axis.scale),
               guide = ..(plot.scatter.guide),
               guide_linetype = ..(guide.line.type),
               guide_alpha = ..(guide.line.alpha),
               guide_color = ..(guide.line.color),
               guide_size = ..(guide.line.size),
               point_shape = ..(point.shape),
               point_color = ..(point.color),
               point_alpha = ..(point.alpha),
               point_size = ..(point.size),
               point_stroke = 1)
      })
  } else if(treeSelected == "CWRES QQ") {
      userPlot <- metaExpr({
         ..(userPlot) %>%
        res_qq(res = "CWRES",
               log = ..(axis.log.type),
               facets = c(..(facetObs), ..(selectedFacet)),
               scales = ..(axis.scale),
               nrow = ..(arrangeRows),
               ncol = ..(arrangeCols),
               page = ..(pageNumber),
               guide = ..(plot.scatter.guide),
               guide_linetype = ..(guide.line.type),
               guide_alpha = ..(guide.line.alpha),
               guide_color = ..(guide.line.color),
               guide_size = ..(guide.line.size),
               point_shape = ..(point.shape),
               point_color = ..(point.color),
               point_alpha = ..(point.alpha),
               point_size = ..(point.size),
               point_stroke = 1)
      })
    # ECWRES QQ ----
  } else if(treeSelected == "ECWRES QQ") {
    userPlot <- metaExpr({
       ..(userPlot) %>%
          set_var_types(res = "ECWRES") %>%
      res_qq(res = "ECWRES",
             log = ..(axis.log.type),
             facets = c(..(facetObs), ..(selectedFacet)),
             scales = ..(axis.scale),
             nrow = ..(arrangeRows),
             ncol = ..(arrangeCols),
             page = ..(pageNumber),
             guide = ..(plot.scatter.guide),
             guide_linetype = ..(guide.line.type),
             guide_alpha = ..(guide.line.alpha),
             guide_color = ..(guide.line.color),
             guide_size = ..(guide.line.size),
             point_shape = ..(point.shape),
             point_color = ..(point.color),
             point_alpha = ..(point.alpha),
             point_size = ..(point.size),
             point_stroke = 1)
    })
    # EWRES QQ ----
  } else if(treeSelected == "EWRES QQ") {
    userPlot <- metaExpr({
       ..(userPlot) %>%
          set_var_types(res = "EWRES") %>%
        res_qq(res = "EWRES",
               log = ..(axis.log.type),
               facets = c(..(facetObs), ..(selectedFacet)),
               scales = ..(axis.scale),
               nrow = ..(arrangeRows),
               ncol = ..(arrangeCols),
               page = ..(pageNumber),
               guide = ..(plot.scatter.guide),
               guide_linetype = ..(guide.line.type),
               guide_alpha = ..(guide.line.alpha),
               guide_color = ..(guide.line.color),
               guide_size = ..(guide.line.size),
               point_shape = ..(point.shape),
               point_color = ..(point.color),
               point_alpha = ..(point.alpha),
               point_size = ..(point.size),
               point_stroke = 1)
    })
    # ETA QQ ----
  } else if(treeSelected == "ETA QQ") {
      userPlot <- metaExpr({
         ..(userPlot) %>%
        eta_qq(facets = c("variable",..(selectedFacet)),
               scales = ..(axis.scale),
               nrow = ..(arrangeRows),
               ncol = ..(arrangeCols),
               page = ..(pageNumber),
               log = ..(axis.log.type),
               guide = ..(plot.scatter.guide),
               guide_linetype = ..(guide.line.type),
               guide_alpha = ..(guide.line.alpha),
               guide_color = ..(guide.line.color),
               guide_size = ..(guide.line.size),
               point_shape = ..(point.shape),
               point_color = ..(point.color),
               point_alpha = ..(point.alpha),
               point_size = ..(point.size),
               point_stroke = 1)
      })
    # IWRES QQ ----
  } else if(treeSelected == "IWRES QQ") {
      userPlot <- metaExpr({
         ..(userPlot) %>%
        res_qq(res = "IWRES",
               log = ..(axis.log.type),
               facets = c(..(facetObs), ..(selectedFacet)),
               scales = ..(axis.scale),
               nrow = ..(arrangeRows),
               ncol = ..(arrangeCols),
               page = ..(pageNumber),
               guide = ..(plot.scatter.guide),
               guide_linetype = ..(guide.line.type),
               guide_alpha = ..(guide.line.alpha),
               guide_color = ..(guide.line.color),
               guide_size = ..(guide.line.size),
               point_shape = ..(point.shape),
               point_color = ..(point.color),
               point_alpha = ..(point.alpha),
               point_size = ..(point.size),
               point_stroke = 1)
      })
      # NPD QQ ----
  } else if(treeSelected == "NPD QQ") {
    userPlot <- metaExpr({
       ..(userPlot) %>%
          set_var_types(res = "NPD") %>%
        res_qq(res = "NPD",
               log = ..(axis.log.type),
               facets = c(..(facetObs), ..(selectedFacet)),
               scales = ..(axis.scale),
               nrow = ..(arrangeRows),
               ncol = ..(arrangeCols),
               page = ..(pageNumber),
               guide = ..(plot.scatter.guide),
               guide_linetype = ..(guide.line.type),
               guide_alpha = ..(guide.line.alpha),
               guide_color = ..(guide.line.color),
               guide_size = ..(guide.line.size),
               point_shape = ..(point.shape),
               point_color = ..(point.color),
               point_alpha = ..(point.alpha),
               point_size = ..(point.size),
               point_stroke = 1)
    })
    # NPDE QQ ----
  } else if(treeSelected == "NPDE QQ") {
    userPlot <- metaExpr({
       ..(userPlot) %>%
          set_var_types(res = "NPDE") %>%
        res_qq(res = "NPDE",
               log = ..(axis.log.type),
               facets = c(..(facetObs), ..(selectedFacet)),
               scales = ..(axis.scale),
               nrow = ..(arrangeRows),
               ncol = ..(arrangeCols),
               page = ..(pageNumber),
               guide = ..(plot.scatter.guide),
               guide_linetype = ..(guide.line.type),
               guide_alpha = ..(guide.line.alpha),
               guide_color = ..(guide.line.color),
               guide_size = ..(guide.line.size),
               point_shape = ..(point.shape),
               point_color = ..(point.color),
               point_alpha = ..(point.alpha),
               point_size = ..(point.size),
               point_stroke = 1)
    })
  # PARAMETER QQ ----
  } else if(treeSelected == "Structural Parameter QQ") {
      userPlot <- metaExpr({
         ..(userPlot) %>%
        prm_qq(facets = c("variable",..(selectedFacet)),
               scales = ..(axis.scale),
               nrow = ..(arrangeRows),
               ncol = ..(arrangeCols),
               page = ..(pageNumber),
               log = ..(axis.log.type),
               guide = ..(plot.scatter.guide),
               guide_linetype = ..(guide.line.type),
               guide_alpha = ..(guide.line.alpha),
               guide_color = ..(guide.line.color),
               guide_size = ..(guide.line.size),
               point_shape = ..(point.shape),
               point_color = ..(point.color),
               point_alpha = ..(point.alpha),
               point_size = ..(point.size),
               point_stroke = 1)
      })
  # PCWRES QQ ----
  } else if(treeSelected == "PCWRES QQ") {
    userPlot <- metaExpr({
       ..(userPlot) %>%
      res_qq(res = "PCWRES",
             log = ..(axis.log.type),
             facets = c(..(facetObs), ..(selectedFacet)),
             scales = ..(axis.scale),
             nrow = ..(arrangeRows),
             ncol = ..(arrangeCols),
             page = ..(pageNumber),
             guide = ..(plot.scatter.guide),
             guide_linetype = ..(guide.line.type),
             guide_alpha = ..(guide.line.alpha),
             guide_color = ..(guide.line.color),
             guide_size = ..(guide.line.size),
             point_shape = ..(point.shape),
             point_color = ..(point.color),
             point_alpha = ..(point.alpha),
             point_size = ..(point.size),
             point_stroke = 1)
    })
# WRES QQ ----
  } else if(treeSelected == "WRES QQ") {
      userPlot <- metaExpr({
         ..(userPlot) %>%
        res_qq(res = "WRES",
               log = ..(axis.log.type),
               facets = c(..(facetObs), ..(selectedFacet)),
               scales = ..(axis.scale),
               nrow = ..(arrangeRows),
               ncol = ..(arrangeCols),
               page = ..(pageNumber),
               guide = ..(plot.scatter.guide),
               guide_linetype = ..(guide.line.type),
               guide_alpha = ..(guide.line.alpha),
               guide_color = ..(guide.line.color),
               guide_size = ..(guide.line.size),
               point_shape = ..(point.shape),
               point_color = ..(point.color),
               point_alpha = ..(point.alpha),
               point_size = ..(point.size),
               point_stroke = 1)
      })
  } else {
        userPlot <- NULL
  }

   if (treeSelected == "Fitness vs Iteration") {
     userPlot <- metaExpr({
         fitness_vs_iteration(darwin_data,
                              annotate = ..(input$annotateBestFitness),
                              annotate.size = ..(input$sizeAnnotate),
                              line.colors = ..(c(input$colorLineMean, input$colorLineMin)),
                              line.type = ..(c(input$typeLineMean, input$typeLineMin)),
                              line.width = ..(c(input$widthLineMean, input$widthLineMin)),
                              legend.position = ..(input$legendPositionDarwin),
                              legend.direction = ..(input$legendDirectionDarwin)
                              )
     })
   } else if (treeSelected == "Penalties vs Iteration") {
     userPlot <- metaExpr({
       fitness_penalties_vs_iteration(darwin_data,
                                      group_penalties = ..(input$groupPenalties),
                                      scale_ofv = ..(input$scaleOFV),
                                      legend.position = ..(input$legendPositionDarwin),
                                      legend.direction = ..(input$legendDirectionDarwin))
     })
   }




  if(!is.null(userPlot)){
    if(!is.null(axis.log.type) &&  grepl("x",axis.log.type)){
      userPlot <- metaExpr({
        ..(userPlot) +
          scale_x_log10(breaks = scales::trans_breaks("log10", function(x) 10^x),
                        labels = scales::trans_format("log10", scales::math_format(10^.x)))
      })
    }
    if(!is.null(axis.log.type) &&  grepl("y",axis.log.type)){
      userPlot <- metaExpr({
        ..(userPlot) +
          scale_y_log10(breaks = scales::trans_breaks("log10", function(x) 10^x),
                        labels = scales::trans_format("log10", scales::math_format(10^.x)))
      })
    }

     if(!isDefaultText){
        userPlot <- metaExpr({
           ..(userPlot) +
        labs(title = ..(title.text),
             subtitle = ..(subtitle.text),
             caption = ..(caption.text),
             x = ..(axis.x.label),
             y = ..(axis.y.label))
        })
     }
     if(isExtraHlines){
        userPlot <- metaExpr({
           ..(userPlot) +
             geom_hline(yintercept = ..(guide.line.extra.y1),
                        linetype = ..(guide.line.type),
                        alpha = ..(guide.line.alpha),
                        color = ..(guide.line.color),
                        size = ..(guide.line.size)) +
             geom_hline(yintercept = ..(guide.line.extra.y2),
                        linetype = ..(guide.line.type),
                        alpha = ..(guide.line.alpha),
                        color = ..(guide.line.color),
                        size = ..(guide.line.size))
        })
     }

    if (isCertaraTheme) {
      if (!treeSelected %in% darwin_trees){
          userPlot <- metaExpr({
            ..(userPlot) +
              theme_certara()
          })
      }
    } else {
       if(background.gridlines && background.border){
      userPlot <- metaExpr({
        ..(userPlot) +
        theme(axis.title.x = element_text(size = ..(axis.size), #Need UI inputs for axis size,color,family,face
                                          color = ..(axis.color),
                                          family = ..(axis.font),
                                          face  = ..(axis.face)),
              axis.title.y = element_text(size = ..(axis.size),
                                          color = ..(axis.color),
                                          family = ..(axis.font),
                                          face  = ..(axis.face)),
              plot.title = element_text(size=..(title.size),  # Consider making these nested under title
                                        color = ..(title.color), #Can add plot options as argument to initialize app
                                        family = ..(title.font), #Make plot options a class
                                        face  = ..(title.face)),
              plot.subtitle = element_text(size =..(subtitle.size),
                                           color = ..(subtitle.color),
                                           family = ..(subtitle.font),
                                           face  = ..(subtitle.face)),
              plot.caption = element_text(size = ..(caption.size),
                                          color = ..(caption.color),
                                          family = ..(caption.font),
                                          face  = ..(caption.face)),
              panel.background = element_rect(fill = ..(background.color)),
              axis.line = element_line(colour = "black"),
              panel.border = element_rect(colour = "black", fill=NA, size=1)
        )
    })
    } else if(!background.gridlines && background.border){
       userPlot <- metaExpr({
          ..(userPlot) +
             theme(axis.title.x = element_text(size = ..(axis.size), #Need UI inputs for axis size,color,family,face
                                               color = ..(axis.color),
                                               family = ..(axis.font),
                                               face  = ..(axis.face)),
                   axis.title.y = element_text(size = ..(axis.size),
                                               color = ..(axis.color),
                                               family = ..(axis.font),
                                               face  = ..(axis.face)),
                   plot.title = element_text(size=..(title.size),  # Consider making these nested under title
                                             color = ..(title.color), #Can add plot options as argument to initialize app
                                             family = ..(title.font), #Make plot options a class
                                             face  = ..(title.face)),
                   plot.subtitle = element_text(size =..(subtitle.size),
                                                color = ..(subtitle.color),
                                                family = ..(subtitle.font),
                                                face  = ..(subtitle.face)),
                   plot.caption = element_text(size = ..(caption.size),
                                               color = ..(caption.color),
                                               family = ..(caption.font),
                                               face  = ..(caption.face)),
                   panel.background = element_rect(fill = ..(background.color)),
                   panel.grid.major = element_blank(),
                   panel.grid.minor = element_blank(),
                   axis.line = element_line(colour = "black"),
                   panel.border = element_rect(colour = "black", fill=NA, size=1)
             )
       })
    } else if(background.gridlines && !background.border){
       userPlot <- metaExpr({
          ..(userPlot) +
             theme(axis.title.x = element_text(size = ..(axis.size), #Need UI inputs for axis size,color,family,face
                                               color = ..(axis.color),
                                               family = ..(axis.font),
                                               face  = ..(axis.face)),
                   axis.title.y = element_text(size = ..(axis.size),
                                               color = ..(axis.color),
                                               family = ..(axis.font),
                                               face  = ..(axis.face)),
                   plot.title = element_text(size=..(title.size),  # Consider making these nested under title
                                             color = ..(title.color), #Can add plot options as argument to initialize app
                                             family = ..(title.font), #Make plot options a class
                                             face  = ..(title.face)),
                   plot.subtitle = element_text(size =..(subtitle.size),
                                                color = ..(subtitle.color),
                                                family = ..(subtitle.font),
                                                face  = ..(subtitle.face)),
                   plot.caption = element_text(size = ..(caption.size),
                                               color = ..(caption.color),
                                               family = ..(caption.font),
                                               face  = ..(caption.face)),
                   panel.background = element_rect(fill = ..(background.color))
             )
       })
     } else {
       userPlot <- metaExpr({
          ..(userPlot) +
             theme(axis.title.x = element_text(size = ..(axis.size), #Need UI inputs for axis size,color,family,face
                                               color = ..(axis.color),
                                               family = ..(axis.font),
                                               face  = ..(axis.face)),
                   axis.title.y = element_text(size = ..(axis.size),
                                               color = ..(axis.color),
                                               family = ..(axis.font),
                                               face  = ..(axis.face)),
                   plot.title = element_text(size=..(title.size),  # Consider making these nested under title
                                             color = ..(title.color), #Can add plot options as argument to initialize app
                                             family = ..(title.font), #Make plot options a class
                                             face  = ..(title.face)),
                   plot.subtitle = element_text(size =..(subtitle.size),
                                                color = ..(subtitle.color),
                                                family = ..(subtitle.font),
                                                face  = ..(subtitle.face)),
                   plot.caption = element_text(size = ..(caption.size),
                                               color = ..(caption.color),
                                               family = ..(caption.font),
                                               face  = ..(caption.face)),
                   panel.background = element_rect(fill = ..(background.color)),
                   panel.grid.major = element_blank(),
                   panel.grid.minor = element_blank()
             )
       })
      }
    }

     if(treeSelected %in% c("Individual Plots (TAD)", "Individual Plots (IVAR)")){
        userPlot <- metaExpr({
           ..(userPlot) +
              theme(legend.position =  ..(ifelse(isShowLegend == TRUE,
                                                 indplots.legend.position, "none")))
        })
     }
  }

  userPlot
}




style_diagnostic <- function(diagnostic, type){
  gg <- metaExpr({
    ..(gg) +
      geom_point(size = ..(input$pointSize)) +
      theme(legend.position = "none")
  })

}


set_log_type <- function(x,y){
  if(x && !y){
    type <- "x"
  } else if(!x && y){
    type <- "y"
  } else if(x && y){
    type <- "xy"
  } else {
    type <- NULL
  }
  type
}

set_plot_scatter_type <- function(points,lines,smoothing,text){
 if(points){
   p <- "p"
 } else {
   p <- NULL
 }
  if(lines){
    l <- "l"
  } else {
    l <- NULL
  }
  if(smoothing){
    s <- "s"
  } else {
    s <- NULL
  }
  if(text){
    t <- "t"
  } else {
    t <- NULL
  }
  type <- paste0(p,l,s,t)
  type
}


set_plot_distribution_type <- function(hist,density,rug){
  if(hist){
    h <- "h"
  } else {
    h <- NULL
  }
  if(density){
    d <- "d"
  } else {
    d <- NULL
  }
  if(rug){
    r <- "r"
  } else {
    r <- NULL
  }

  type <- paste0(h,d,r)
  type
}

set_rug_type <- function(rugtype){
  if(rugtype == "top"){
    type <- "t"
  } else if (rugtype == "bottom"){
    type <- "b"
  } else {
    type <- "tb"
  }
}


font_to_family <- function(font_name){
  if(font_name == "Times New Roman"){
    font_family <- "serif"
  } else if (font_name == "Arial") {
    font_family <- "sans"
  } else {
    font_family <- "mono"
  }
  return(font_family)
}

has_type <- function (index, type = "eta") {
   col_types <- index %>% dplyr::pull(.data$type)
   exists <- type %in% col_types
   return(exists)
}

check_vars <- function(var, treeSelected, cols) {
   tree_branch <- attr(treeSelected[[1]], "ancestry")

   for (i in var) {
      if (!(tree_branch %in% c("Darwin Search", "Tables")) && !(i %in% c("Individual", "Structural", "Covariate", "ETA")) && grepl(i, treeSelected) && !(i %in% cols)) {
         stop(paste(i, "not found in data. Check NONMEM $TABLE statements."))
      }
   }
}

check_types <- function(var, hasEta = FALSE, hasParam = FALSE) {

   if ("ETA" %in% var && !hasEta) {
      stop("No ETAs found in data. Check NONMEM $TABLE statements.")
   }

   if ("Structural" %in% var && !hasParam) {
      stop("No structural parameters found in data. Check NONMEM $TABLE statements.")
   }
}
