% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovc-rccoor.R
\encoding{UTF-8}
\name{catr_ovc_get_rccoor}
\alias{catr_ovc_get_rccoor}
\title{OVCCoordenadas: Reverse geocode a cadastral reference}
\usage{
catr_ovc_get_rccoor(lat, lon, srs = 4326, verbose = FALSE)
}
\arguments{
\item{lat}{Latitude to use on the query. It should be specified in the
CRS/SRS defined in \code{srs}.}

\item{lon}{Longitude to use on the query. It should be specified in the
CRS/SRS defined in \code{srs}.}

\item{srs}{SRS/CRS to use on the query. To check the admitted values check
\link{catr_srs_values}, specifically the \code{ovc_service} column.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A \link[tibble:tbl_df-class]{tibble}. See \strong{Details}
}
\description{
Implementation of the OVCCoordenadas service
\href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccoordenadas.asmx?op=Consulta_RCCOOR}{Consulta RCCOOR}.

Returns the cadastral reference found for a set of specific coordinates.
}
\details{
When the API does not provide any result, the function returns a
\link[tibble:tbl_df-class]{tibble} with the input arguments only.

On a successful query, the function returns a \link[tibble:tbl_df-class]{tibble} with
one row by cadastral reference, including the following columns:
\itemize{
\item \code{geo.xcen}, \code{geo.ycen}, \code{geo.srs}: Input arguments of the query.
\item \code{refcat}: Cadastral Reference.
\item \code{address}: Address as it is recorded on the Cadastre.
\item Rest of fields: Check the API Docs.
}
}
\examples{
\dontshow{if (run_example()) withAutoprint(\{ # examplesIf}
\donttest{
catr_ovc_get_rccoor(
  lat = 38.6196566583596,
  lon = -3.45624183836806,
  srs = 4326
)
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccoordenadas.asmx?op=Consulta_RCCOOR}{Consulta RCCOOR}.
}
\seealso{
\link{catr_srs_values}, \code{vignette("ovcservice", package = "CatastRo")}

OVCCoordenadas API:
\code{\link{catr_ovc_get_cpmrc}()},
\code{\link{catr_ovc_get_rccoor_distancia}()},
\code{\link{catr_srs_values}}

Other cadastral references: 
\code{\link{catr_ovc_get_cpmrc}()},
\code{\link{catr_ovc_get_rccoor_distancia}()}
}
\concept{OVCCoordenadas}
\concept{cadastral references}
