% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov.patterns.R
\name{cov.patterns}
\alias{cov.patterns}
\title{Extract Unique Covariate Patterns from a Logistic Regression Model}
\usage{
cov.patterns(model)
}
\arguments{
\item{model}{A fitted logistic regression model object, typically from \code{glm()} with \code{family = binomial}.}
}
\value{
A data frame where each row corresponds to a unique covariate pattern. The output includes:
\describe{
\item{\code{y_j}}{The number of observed events (cases) for each pattern.}
\item{\code{m}}{The number of observations sharing that pattern.}
\item{\code{est.prob}}{The estimated probability from the fitted model for that pattern.}
\item{\code{Covariate columns}}{The covariates used in the model, showing the pattern structure.}
}
}
\description{
Returns a summary of unique covariate patterns from a fitted logistic regression model, including
the number of observations per pattern and the estimated probability.
}
\details{
This function summarizes the unique covariate patterns in the data, capturing the combinations of
predictor values across observations. It calculates the frequency of each pattern, the number of events (cases),
and the estimated probability for each combination of covariates.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 5

# Recode 'raterisk' into a binary variable 'raterisk_cat'
glow500 <- dplyr::mutate(
  glow500,
  raterisk_cat = dplyr::case_when(
    raterisk \%in\% c("Less", "Same") ~ "C1",
    raterisk == "Greater" ~ "C2"
  )
)

# Fit a multiple logistic regression model with interactions
model.int <- glm(
  fracture ~ age + height + priorfrac + momfrac + armassist +
    raterisk_cat + age * priorfrac + momfrac * armassist,
  family = binomial,
  data = glow500
)

# Examine covariate patterns from the fitted model
X.cv <- cov.patterns(model.int)
head(X.cv, n=10)

}
