% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsBioTIME.R
\name{plotSlopes}
\alias{plotSlopes}
\title{Plot slopes BioTIME}
\usage{
plotSlopes(
  x,
  metric,
  cols,
  taxa = c("Amphibians & reptiles", "Birds", "Chromista", "Fish", "Fungi", "Mammals",
    "Plants"),
  method = c("metric", "taxa", "ind"),
  assemblageID,
  divType = c("alpha", "beta")
)
}
\arguments{
\item{x}{A data.frame with columns slopes, metric, taxa, assemblageID}

\item{metric}{If \code{divtype} is alpha, \code{metric} must be one of "S",
"N", "maxN", "Shannon", "Simpson", "invSimpson", "PIE", "DomMc" or
"expShannon".
If \code{divtype} is beta, \code{metric} must be one of "JaccardDiss",
"MorisitaHornDiss" or "BrayCurtisDiss".}

\item{cols}{Name of the column in x from which colouring groups will be based
on.}

\item{taxa}{Necessary if method = "taxa", one of: "Amphibians & reptiles",
"Birds", "Chromista", "Fish", "Fungi", "Mammals", "Plants"}

\item{method}{Character can be one of "metric", "taxa", "ind"}

\item{assemblageID}{Parameter description}

\item{divType}{"alpha" or "beta"}
}
\value{
A plot
}
\description{
Plot slopes BioTIME
}
\keyword{internal}
