% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_sgwt_decomposition}
\alias{plot_sgwt_decomposition}
\title{Plot SGWT decomposition results}
\usage{
plot_sgwt_decomposition(SG, signal_name = NULL, plot_scales = NULL, ncol = 3)
}
\arguments{
\item{SG}{SGWT object with Forward and Inverse results computed}

\item{signal_name}{Name of signal to plot (default: first signal)}

\item{plot_scales}{Which wavelet scales to plot (default: first 4)}

\item{ncol}{Number of columns in the plot layout (default: 3)}
}
\value{
ggplot object with combined plots
}
\description{
Visualize SGWT decomposition components including original signal,
scaling function, wavelet coefficients, and reconstructed signal
}
\examples{
\donttest{
# Create and analyze example data
data <- data.frame(x = runif(100), y = runif(100), signal1 = rnorm(100))
SG <- initSGWT(data, signals = "signal1")
SG <- runSpecGraph(SG, k = 15)
SG <- runSGWT(SG)

# Plot decomposition
plots <- plot_sgwt_decomposition(SG, signal_name = "signal1")
print(plots)
}
}
