% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_FM}
\alias{plot_FM}
\title{Plot Fourier modes (eigenvectors) from SGWT object}
\usage{
plot_FM(SG, mode_type = "both", n_modes = 6, ncol = 3, point_size = 1.5)
}
\arguments{
\item{SG}{SGWT object with Graph slot computed (from runSpecGraph)}

\item{mode_type}{Type of modes to plot: "low", "high", or "both" (default: "both")}

\item{n_modes}{Number of modes to plot for each type (default: 6)}

\item{ncol}{Number of columns in plot layout (default: 3)}

\item{point_size}{Size of points in the plot (default: 1.5)}
}
\value{
Combined plot of Fourier modes
}
\description{
Plot low-frequency and high-frequency Fourier modes (eigenvectors) 
from the graph Laplacian eigendecomposition in an SGWT object
}
\examples{
\donttest{
# Create example data
data <- data.frame(x = runif(100), y = runif(100), signal = rnorm(100))

# Plot both low and high frequency modes
SG <- initSGWT(data, signals = "signal")
SG <- runSpecGraph(SG, k = 15)
plot_FM(SG, mode_type = "both", n_modes = 4)

# Plot only low frequency modes
plot_FM(SG, mode_type = "low", n_modes = 8)
}
}
