% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdCorr_matrix}
\alias{bdCorr_matrix}
\title{Compute correlation matrix for in-memory matrices (unified function)}
\usage{
bdCorr_matrix(
  X,
  Y = NULL,
  trans_x = NULL,
  trans_y = NULL,
  method = NULL,
  use_complete_obs = NULL,
  compute_pvalues = NULL,
  threads = NULL
)
}
\arguments{
\item{X}{First numeric matrix (observations in rows, variables in columns)}

\item{Y}{Second numeric matrix (optional, observations in rows, variables in columns)}

\item{trans_x}{Logical, whether to transpose matrix X (default: FALSE)}

\item{trans_y}{Logical, whether to transpose matrix Y (default: FALSE, ignored if Y not provided)}

\item{method}{Character string indicating correlation method ("pearson" or "spearman", default: "pearson")}

\item{use_complete_obs}{Logical, whether to use only complete observations (default: TRUE)}

\item{compute_pvalues}{Logical, whether to compute p-values for correlations (default: TRUE)}

\item{threads}{Integer, number of threads for parallel computation (optional, default: -1 for auto)}
}
\value{
A list containing correlation results
}
\description{
Compute Pearson or Spearman correlation matrix for matrices that fit in memory.
This function automatically detects whether to compute:
\itemize{
\item Single matrix correlation cor(X) - when only matrix X is provided
\item Cross-correlation cor(X,Y) - when both matrices X and Y are provided
}
}
\examples{
\dontrun{
# Backward compatible - existing code unchanged
set.seed(123)
X <- matrix(rnorm(1000), ncol = 10)
result_original <- bdCorr_matrix(X)

# Create omics-style data
gene_expr <- matrix(rnorm(5000), nrow = 100, ncol = 50)  # 100 samples × 50 genes

# Gene-gene correlations (variables)
gene_corr <- bdCorr_matrix(gene_expr, trans_x = FALSE)

# Sample-sample correlations (individuals)  
sample_corr <- bdCorr_matrix(gene_expr, trans_x = TRUE)

# Cross-correlation examples
methylation <- matrix(rnorm(4000), nrow = 100, ncol = 40)  # 100 samples × 40 CpGs

# Variables vs variables (genes vs CpGs)
vars_vs_vars <- bdCorr_matrix(gene_expr, methylation, 
                             trans_x = FALSE, trans_y = FALSE)

# Samples vs variables (individuals vs CpGs)
samples_vs_vars <- bdCorr_matrix(gene_expr, methylation,
                                trans_x = TRUE, trans_y = FALSE)
}

}
