% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prewhitening.R
\name{pw_smooth}
\alias{pw_smooth}
\title{Smooth AR coefficients and white noise variance}
\usage{
pw_smooth(spatial, AR, var, FWHM = 5)
}
\arguments{
\item{spatial}{See \code{fit_bayesglm} internal code.}

\item{AR}{A Vxp matrix of estimated AR coefficients, where V is the number of vertices and p is the AR model order}

\item{var}{A vector length V containing the white noise variance estimates from the AR model}

\item{FWHM}{FWHM parameter for smoothing. Remember that
\eqn{\sigma = \frac{FWHM}{2*sqrt(2*log(2)}}. Set to \code{0} or \code{NULL}
to not do any smoothing. Default: \code{5}.}
}
\value{
Smoothed AR coefficients and residual variance at every vertex
}
\description{
Smooth AR coefficients and white noise variance
}
\keyword{internal}
