% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_plot.R
\name{trace_plot}
\alias{trace_plot}
\title{Create Trace Plots for BayesMallowsSMC2 Objects}
\usage{
trace_plot(x, parameter = "alpha", ...)
}
\arguments{
\item{x}{An object of class \code{BayesMallowsSMC2}, returned from
\code{\link[=compute_sequentially]{compute_sequentially()}} with \code{trace = TRUE} in \code{\link[=set_smc_options]{set_smc_options()}}.}

\item{parameter}{Character string defining the parameter to plot. Available
options are \code{"alpha"} (default) and \code{"tau"}.}

\item{...}{Other arguments (currently unused).}
}
\value{
A ggplot object showing the evolution of the parameter over time.
For each timepoint, the plot shows:
\itemize{
\item The weighted mean (solid line)
\item The weighted 0.025 and 0.975 quantiles (shaded area representing
the 95\% credible interval)
}
}
\description{
Visualize the timeseries dynamics of the alpha and tau parameters across
timepoints. This function creates trace plots similar to Figure 4 (left) in
\insertRef{10.1214/25-BA1564}{BayesMallowsSMC2}.
}
\details{
This function requires that the model was fitted with \code{trace = TRUE} in the
\code{smc_options}. The trace contains the parameter values at each timepoint,
which allows visualization of how the posterior distribution evolves as more
data arrives sequentially.

For mixture models (multiple clusters), separate trace plots are created for
each cluster using faceting.

The shaded area represents the 95\% credible interval (from 2.5\% to 97.5\%
quantiles) of the posterior distribution at each timepoint, computed using
the importance weights from the SMC algorithm.
}
\examples{
\donttest{
# Fit a model with trace enabled
mod <- compute_sequentially(
  complete_rankings,
  hyperparameters = set_hyperparameters(n_items = 5),
  smc_options = set_smc_options(
    n_particles = 100,
    n_particle_filters = 1,
    trace = TRUE
  )
)

# Create trace plot for alpha (default)
trace_plot(mod)
}
}
\references{
\insertRef{10.1214/25-BA1564}{BayesMallowsSMC2}
}
