% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DetectCpObj.R
\name{plot.DetectCpObj}
\alias{plot.DetectCpObj}
\title{Plot estimated change points}
\usage{
\method{plot}{DetectCpObj}(
  x,
  y = NULL,
  plot_freq = FALSE,
  loss = "VI",
  maxNClusters = 0,
  nRuns = 16,
  maxZealousAttempts = 10,
  ...
)
}
\arguments{
\item{x}{an object of class \code{DetectCpObj}.}

\item{y, ...}{parameters of the generic method.}

\item{plot_freq}{if TRUE also the histogram with the empirical frequency of each change point is plotted.}

\item{loss}{The loss function used to estimate the final partition, it can be "VI", "binder", "omARI", "NVI", "ID", "NID".}

\item{maxNClusters}{maximum number of clusters in salso procedure.}

\item{nRuns}{number of runs in salso procedure.}

\item{maxZealousAttempts}{maximum number of zealous attempts in salso procedure.}
}
\value{
The function returns a ggplot object representing the detected change points. If \code{plot_freq = TRUE} is plotted also an histogram with the frequency of times that a change point has been detected in the MCMC chain.
}
\description{
The \code{plot} method plots the estimated change points estimated through the salso algorithm, for a \code{DetectCpObj} class object.
}
\examples{

## Univariate time series

data("eu_inflation")

params_uni <- list(a = 1, b = 1, c = 1, prior_var_phi = 0.1,
                   prior_delta_c = 1, prior_delta_d = 1)

out <- detect_cp(data = eu_inflation[1,], n_iterations = 1000,
                 n_burnin = 100, q = 0.5, params = params_uni,
                 kernel = "ts")

plot(out)

}
