% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help.R
\name{arguments.series}
\alias{arguments.series}
\title{Shared documentation for the time series}
\arguments{
\item{n}{the sample size of the output time series \code{yt} after burn-in
(simulation only). Default is \code{n = 1}.}

\item{nnew}{optional; the number of out-of sample predicted values required
(extract and fit only). Default is \code{nnew = 0}.}

\item{burn}{the length of the \sQuote{burn-in} period (simulation only).
Default is \code{burn = 0}. The first \code{burn} values of the time series are
discarded.}

\item{yt}{numeric vector with the observed time series (extract and fit
only). Missing values (NA's) are not allowed.}

\item{y.start}{optional; an initial value for \eqn{Y_t} (to initialize
recursions when \eqn{t < 1}). Default is \code{y.start = NULL}, in which case,
the recursion assumes that \eqn{Y_t = g_{12}^{-1}(0)}, for \eqn{t < 1}.
Only relevant if \eqn{p > 0}.}

\item{rho}{the quantile being considered in the conditional distribution of
\eqn{Y_t} (only present in Kumaraswamy and Unit-Weibull based models). It
can be any positive number between 0 and 1. Default is \code{rho = 0.5}, which
corresponds to the median.}

\item{y.lower}{the lower limit for the Kumaraswamy density support. Default
is \code{y.lower = 0}.}

\item{y.upper}{the upper limit for the Kumaraswamy density support. Default
is \code{y.upper = 1}.}

\item{vt.start}{optional; an initial value for  \eqn{\vartheta_t} (to
initialize recursions when \eqn{t < 1}). Default is \code{vt.start = NULL}, in
which case, the recursion assumes that \eqn{\vartheta_t = g_{22}^{-1}(0)},
for \eqn{t < 1}. Only relevant if \eqn{\nu} is time-varying and \eqn{p_2 >
  0}.}

\item{e2.start}{optional; an initial value for  \eqn{g_{23}(e_{1t})} (to
initialize recursions when \eqn{t < 1}). Default is \code{e2.start = NULL}, in
which case, the recursion assumes that \eqn{e_{1t} = g_{23}^{-1}(0)}, for
\eqn{t < 1}. Only relevant if \eqn{\nu} is time-varying and \eqn{q_2 > 0}
or \eqn{d_2 > 0}.}
}
\description{
This is the common documentation for arguments related to the
observed/simulated time series and its conditional distribution.
}
