#' @title  Simulate sample of factor loadings, B
#' @description  Simulates a sample of factor loadings matrix, B from its posterior (Gaussian)
#'
#' @param model.attributes  Model attributes generated by \code{initialize.model.attributes}
#' @param parm  The whole parameters from current iteration
#' @param data  The dataset
#' 
#' @importFrom stats rnorm
#'
#' @return  A sample of B
#' @noRd

simulated.B = function(model.attributes, parm, data){
  # Simulate b_j, j = k+1, ..., r
  XtX = matrix(0,model.attributes$L,model.attributes$L)
  XtY = matrix(0,model.attributes$L,model.attributes$R)
  for(tt in 1:model.attributes$times){
    XtX = XtX + t(parm$X[,,tt]) %*% parm$X[,,tt]
    XtY = XtY + t(parm$X[,,tt]) %*% data[,,tt]
  }
  
  identity.k = diag(model.attributes$L)  
  # Simulate values from k + 1th row 
  for(j in (model.attributes$L+1):model.attributes$R)
  {
    var.aux = solve( XtX / parm$sigma2[j] + identity.k*(1/parm$tau2))
    mean.aux = var.aux %*% XtY[,j] / parm$sigma2[j]
    chol.var.aux = chol(var.aux)
    parm$B[j,] = mean.aux + t(chol.var.aux) %*% rnorm(model.attributes$L)
  }
  
  # Simulate values from 2nd to kth rows
  if(model.attributes$L > 1){
    for(j in 2:model.attributes$L)
    {
      XtX = matrix(0,j-1,j-1)
      XtY = matrix(0,j-1,1)
      for(tt in 1:model.attributes$times){
        XtX = XtX + t(parm$X[,1:(j-1),tt]) %*% parm$X[,1:(j-1),tt]
        XtY = XtY + t(parm$X[,1:(j-1),tt]) %*% (data[,j,tt] - parm$X[,j,tt])
      }
      var.aux = solve( XtX / parm$sigma2[j] + diag(j-1)*(1/parm$tau2[1:(j-1)]))
      mean.aux = var.aux %*% XtY / parm$sigma2[j]
      chol.var.aux = chol(var.aux)  
      parm$B[j,1:(j-1)] = mean.aux + t(chol.var.aux) %*% rnorm(j-1)
    }
  }
  
  
  return(parm)
}
