% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.table.sumry.lm.R
\name{print.table.sumry.lm}
\alias{print.table.sumry.lm}
\title{Print a Table from Linear Model Summary}
\usage{
\method{print}{table.sumry.lm}(
  x,
  ...,
  digits = max(4, getOption("digits") - 2),
  quote = FALSE,
  na.print = "",
  zero.print = "0",
  right = TRUE,
  justify = "right",
  signif.stars = getOption("show.signif.stars"),
  eps = .Machine$double.eps,
  nsmall = 4,
  prnt.lgnd = c("coefficients"),
  dig.test = max(1, min(5, digits - 2))
)
}
\arguments{
\item{x}{A table object from a linear model sumry (e.g., coefficients, ANOVA, statistics, correlation matrices).}

\item{...}{Additional arguments (not currently used).}

\item{digits}{Number of significant digits to print. Defaults to \code{max(4, getOption("digits") - 2)}.}

\item{quote}{Logical; whether to print with quotes (default: FALSE).}

\item{na.print}{String to use for NA values (default: ").}

\item{zero.print}{String to use for 0 values (default: 0).}

\item{right}{Logical, indicating whether or not strings should be right aligned (default: TRUE).}

\item{justify}{Justification for columns ("right" or "left"; default: "right").}

\item{signif.stars}{Logical; whether to show significance stars for p-values (default: \code{getOption("show.signif.stars")}).}

\item{eps}{Smallest positive floating-point value for formatting near-zero p-values (default: \code{.Machine$double.eps}).}

\item{nsmall}{Minimum number of digits to the right of the decimal point (default: 4).}

\item{prnt.lgnd}{Character vector naming tables to print significance legends for (default: \code{"coefficients"}).}

\item{dig.test}{Digits for hypothesis test statistics (default: \code{max(1, min(5, digits - 2))}).}
}
\value{
Invisibly returns the input table.
}
\description{
Prints a formatted table from a sumry of a linear model, including coefficients, ANOVA, correlation matrices, or summary statistics. Significance stars and legends are added as appropriate.
}
\details{
This method handles tabular output from linear model sumry.lm, including coefficients, ANOVA, statistics, and correlation/covariance matrices. It formats p-values, adds significance stars, and prints appropriate legends for hypothesis tests.
}
\examples{
mdl <- lm(Sepal.Length ~ Sepal.Width, data = iris)
sum_mdl <- sumry(mdl)
print(sum_mdl$coefficients)

}
\seealso{
\code{\link{print.sumry.lm}}
}
