% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbatim_logical.R
\name{verbatim_logical}
\alias{verbatim_logical}
\title{Alternative logical handler}
\usage{
verbatim_logical(x)
}
\arguments{
\item{x}{Logical vector to convert to \code{true}/\code{false}.}
}
\value{
Returns a vector of strings of either \code{true} or \code{false} of
class \code{verbatim}.
}
\description{
A yaml handler function that causes logical vectors to emit
\code{true}/\code{false} instead of \code{yes}/\code{no} values.
}
\details{
Pass this function to \code{\link[=as.yaml]{as.yaml()}} as part of the
\code{handlers} argument list like \code{list(logical = verbatim_logical)}.
}
\examples{

vector <- c(TRUE, FALSE, TRUE)

as.yaml(vector, handlers=list(logical=verbatim_logical))

}
\seealso{
\code{\link[=as.yaml]{as.yaml()}}
}
\author{
Charles Dupont and James Goldie (jimjam-slam)
}
\keyword{data}
\keyword{manip}
