% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmixr2.R
\name{attach_nlmixr2}
\alias{attach_nlmixr2}
\title{Attach nlmixr2 fit object to xpose data object}
\usage{
attach_nlmixr2(xpdb, obj)
}
\arguments{
\item{xpdb}{<\code{xpose_data}> The object upon which to attach the fit}

\item{obj}{<\code{nlmixr2FitData}> Result of the nlmixr2 fit}
}
\value{
An object of the same class as \code{xpdb} with an additional element.
}
\description{
Attach nlmixr2 fit object to xpose data object
}
\examples{
\dontrun{
# Based on an example from nlmixr2 documentation
if (rlang::is_installed("nlmixr2") &&
    rlang::is_installed("nlmixr2data")) {
  one.cmt <- function() {
    ini({
      tka <- 0.45 # Ka
      tcl <- log(c(0, 2.7, 100)) # Log Cl
      tv <- 3.45; label("log V")
      eta.ka ~ 0.6
      eta.cl ~ 0.3
      eta.v ~ 0.1
      add.sd <- 0.7
    })
    model({
      ka <- exp(tka + eta.ka)
      cl <- exp(tcl + eta.cl)
      v <- exp(tv + eta.v)
      linCmt() ~ add(add.sd)
    })
  }

  theo_sd_fit <- nlmixr2::nlmixr2(one.cmt, nlmixr2data::theo_sd,
      "focei", control=nlmixr2::foceiControl(print=0))

  attach_nlmixr2(
    xpdb_nlmixr2, theo_sd_fit
  ) \%>\%
  as_xpdb_x() \%>\%
  print() # fit will be mentioned in print() method
}
}
}
