% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diag_constants.R
\name{derive_prm}
\alias{derive_prm}
\alias{backfill_derived}
\title{Derive full parameter set for mammillary PK model}
\usage{
derive_prm(
  xpdb,
  .prm = NULL,
  .problem,
  quiet = xpdb$options$quiet,
  prefix = ""
)

backfill_derived(
  xpdb,
  .prm = NULL,
  .problem,
  quiet = xpdb$options$quiet,
  ...,
  group_vars = "id"
)
}
\arguments{
\item{xpdb}{xpdb <\code{xpose_data}> object}

\item{.prm}{<\code{tidyselect}> Parameters to convert (if \code{NULL}, the function
will use \code{xp_var} \code{param} types)}

\item{.problem}{Optional. Problem to use.}

\item{quiet}{Optional. Extra output.}

\item{prefix}{If desired, apply prefix to new parameters.}

\item{...}{Passed to \code{derive_prm()}}

\item{group_vars}{Variable type(s) to join derived parameters on.}
}
\value{
<\code{data.frame}> of data with new parameters
}
\description{
This function applies \code{\link[rxode2:rxDerived]{rxode2::rxDerived}} to model parameters.
}
\examples{
if (!rlang::is_installed("rxode2") ||
   !exists("rxDerived", envir = rlang::ns_env("rxode2"))) {

nlmixr2_m3 \%>\%
  backfill_derived() \%>\%
  list_vars()

derive_prm(nlmixr2_m3)


# If param has no vars, .prm should be set
pheno_base \%>\%
  backfill_derived(
    .prm = c(CL,V)
  ) \%>\%
  list_vars()
}
}
