% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooling.R
\name{PowerMultiplicativeCooling}
\alias{PowerMultiplicativeCooling}
\title{Power multiplicative cooling.}
\usage{
PowerMultiplicativeCooling(k, lF)
}
\arguments{
\item{k}{Number of steps to discount.}

\item{lF}{Local configuration.}
}
\value{
Temperature at time k.
}
\description{
This schedule decreases by the inverse proportion of 
             a power 
             of \code{k}. \code{lF$Alpha()} should be larger than 1.
}
\details{
Temperature is updated at the end of each generation
         in the main loop of the genetic algorithm.
         For \code{lF$CoolingPower()==1} and 
             \code{lF$CoolingPower()==2} this results in the 
         the linear and quadratic multiplicative cooling schemes 
         in A Comparison of Cooling Schedules for Simulated Annealing.
         \code{lF$Temp0()} is the starting temperature.
         \code{lF$Alpha()} is a scaling factor.
         \code{lF$CoolingPower()} is an exponential factor.
}
\examples{
parm<-function(x){function() {return(x)}}
lF<-list(Temp0=parm(100), Alpha=parm(1.01), CoolingPower=parm(2))
PowerMultiplicativeCooling(0, lF)
PowerMultiplicativeCooling(2, lF)
}
\references{
The-Crankshaft Publishing (2023)
         A Comparison of Cooling Schedules for Simulated Annealing.
  <https://what-when-how.com/artificial-intelligence/a-comparison-of-cooling-schedules-for-simulated-annealing-artificial-intelligence/>
}
\seealso{
Other Cooling: 
\code{\link{ExponentialAdditiveCooling}()},
\code{\link{ExponentialMultiplicativeCooling}()},
\code{\link{LogarithmicMultiplicativeCooling}()},
\code{\link{PowerAdditiveCooling}()},
\code{\link{TrigonometricAdditiveCooling}()}
}
\concept{Cooling}
