% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spectra.R
\name{plot_spectra}
\alias{plot_spectra}
\title{Plot spectral data, highlighting outliers as identified using
 Mahalanobis distance}
\usage{
plot_spectra(
  df,
  num.col.before.spectra = 1,
  window.size = 10,
  detect.outliers = TRUE,
  color = NULL,
  alternate.title = "",
  verbose = TRUE,
  wavelengths = deprecated()
)
}
\arguments{
\item{df}{\code{data.frame} object containing columns of spectra.
Spectral columns must be labeled with an "X" and then the wavelength
(example: "X740" = 740nm). Left-most column must be unique ID. May also
contain columns of metadata between the unique ID and spectral columns.
Cannot contain any missing values. Metadata column names may not start
with "X".}

\item{num.col.before.spectra}{Number of columns to the left of the spectral
matrix (including unique ID). Default is 1.}

\item{window.size}{number defining the size of window to use when calculating
the covariance of the spectra (required to calculate Mahalanobis distance).
Default is 10.}

\item{detect.outliers}{Boolean indicating whether spectra should be filtered
before plotting. If \code{TRUE}, outliers are indicated by color in the
resulting plot. If \code{verbose} is also set to \code{TRUE}, outlier
metadata will be printed to the console. Default is \code{TRUE}.}

\item{color}{String or vector of strings indicating colors to be passed to
\code{\link[ggplot2]{ggplot}}. Default is default
\code{\link[ggplot2]{ggplot}} colors.}

\item{alternate.title}{String to be used as plot title. If
\code{detect.outliers} is \code{TRUE}, a descriptive title will be supplied.
If \code{detect.outliers} is \code{FALSE}, default is no title will be used.}

\item{verbose}{If \code{TRUE}, the number of rows removed through filtering
will be printed to the console. Default is \code{TRUE}.}

\item{wavelengths}{DEPRECATED \code{wavelengths} is no
longer supported; this information is now inferred from
\code{df} column names}
}
\value{
If verbose, prints unique ID and metadata for rows identified as
outliers. Returns plot of spectral data with non-outliers in blue and
outliers in red. X-axis is wavelengths and y-axis is spectral values.
}
\description{
Generates a \code{\link[ggplot2]{ggplot}} object of given
 spectra, with wavelength on the x axis and given spectral values on the y.
 Mahalanobis distance is used to calculate outliers, which are both
 identified on the plot. Rows from the original dataframe are printed to the
 console for each outlier that is identified.
}
\examples{
\donttest{
library(magrittr)
ikeogu.2017 \%>\%
  dplyr::rename(unique.id = sample.id) \%>\%
  dplyr::select(unique.id, dplyr::everything(), -TCC) \%>\%
  na.omit() \%>\%
  plot_spectra(
    df = .,
    num.col.before.spectra = 5,
    window.size = 15,
    detect.outliers = TRUE,
    color = NULL,
    alternate.title = NULL,
    verbose = TRUE
  )
}
}
\author{
Jenna Hershberger \email{jmh579@cornell.edu}
}
