% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_estimates.R
\name{combine_estimates}
\alias{combine_estimates}
\title{Combine MSE estimation results for a given stratum calculated
using multiple replicate files created using multiple imputation. Combination
is done using the standard approach that makes use of the laws of total
expectation and total variance.}
\usage{
combine_estimates(stratum_estimates)
}
\arguments{
\item{stratum_estimates}{A data frame of estimates for a stratum of interest
calculated using \code{mse} for all replicates being used for the analysis. The
data frame should have columns \code{N} and \code{n_obs} from the \code{mse} function and an
additional column \code{replicate} indicating which replicate the estimates were
calculated on.}
}
\value{
A data frame row with the point estimate (\code{N_mean}) and the
associated 95\% uncertainty interval (lower bound is \code{N_025}, upper bound is
\code{N_975}).
}
\description{
Combine MSE estimation results for a given stratum calculated
using multiple replicate files created using multiple imputation. Combination
is done using the standard approach that makes use of the laws of total
expectation and total variance.
}
\examples{
\donttest{
set.seed(19481210)

library(dplyr)
library(purrr)
library(glue)


simulate_estimates <- function(stratum_data, replicate_num) {

    # simulate an imputed stratification variable to determine whether a record
    # should be considered part of the stratum for estimation
    stratification_var <- sample(c(0, 1), size = 100,
                                 replace = TRUE, prob = c(0.1, 0.9))

    my_stratum <- bind_cols(my_stratum, tibble::tibble(stratification_var)) \%>\%
        filter(stratification_var == 1)

    results <- mse(my_stratum, "my_stratum", K = 4) \%>\%
        mutate(replicate = replicate_num)

    return(results)

}


in_A <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.45, 0.65))
in_B <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.5, 0.5))
in_C <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.75, 0.25))

my_stratum <- tibble::tibble(in_A, in_B, in_C)

replicate_nums <- glue("R{1:20}")

estimates <- map_dfr(.x = replicate_nums,
             .f = ~simulate_estimates(stratum_data = my_stratum, replicate_num = .x))

combine_estimates(estimates)

}
}
\references{
\insertRef{BDA3}{verdata}
}
