% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surface_parametric_area.R
\name{surface_parametric_area}
\alias{surface_parametric_area}
\title{Plot a parametric surface and estimate its area}
\usage{
surface_parametric_area(
  xfun,
  yfun,
  zfun,
  urange = c(0, 2 * pi),
  vrange = c(0, 2 * pi),
  nu = 160,
  nv = 160,
  h_u = NULL,
  h_v = NULL,
  title_prefix = "r(u,v)"
)
}
\arguments{
\item{xfun}{Function of two arguments (u, v) returning the
x-coordinate of the surface.}

\item{yfun}{Function of two arguments (u, v) returning the
y-coordinate of the surface.}

\item{zfun}{Function of two arguments (u, v) returning the
z-coordinate of the surface.}

\item{urange}{Numeric vector of length 2 giving the interval
for the parameter u, \code{c(u_min, u_max)} with \code{u_max > u_min}.}

\item{vrange}{Numeric vector of length 2 giving the interval
for the parameter v, \code{c(v_min, v_max)} with \code{v_max > v_min}.}

\item{nu}{Integer, number of grid points along u (recommended:
at least 20 for a reasonable surface).}

\item{nv}{Integer, number of grid points along v (recommended:
at least 20).}

\item{h_u}{Numeric step size for finite differences in u.
If \code{NULL}, a default based on the grid spacing is used.}

\item{h_v}{Numeric step size for finite differences in v.
If \code{NULL}, a default based on the grid spacing is used.}

\item{title_prefix}{Character string used in the plot title.}
}
\value{
A list with:
\itemize{
\item \code{plot}: a \pkg{plotly} surface object showing the
parametric surface.
\item \code{area}: numeric estimate of the surface area.
\item \code{grid}: list with elements \code{U}, \code{V}, \code{X},
\code{Y}, and \code{Z}, representing the parameter values and
evaluated surface.
}
}
\description{
This function plots a smooth parametric surface defined by
functions x(u,v), y(u,v), and z(u,v). It also estimates the
surface area using a trapezoidal approximation based on the
magnitudes of partial-derivative cross products.
}
\details{
The parametric domain is given by ranges for u and v, and
the surface is evaluated on a regular grid with sizes
specified by \code{nu} and \code{nv}. Finite differences are used to
approximate partial derivatives with respect to u and v.
}
\examples{
\dontshow{if (interactive()) \{}
# Example: torus-like parametric surface
xfun <- function(u, v) (2 + cos(v)) * cos(u)
yfun <- function(u, v) (2 + cos(v)) * sin(u)
zfun <- function(u, v) sin(v)
result <- surface_parametric_area(
  xfun, yfun, zfun,
  urange = c(0, 2*pi),
  vrange = c(0, 2*pi),
  nu = 80, nv = 80
)
result$area
\dontshow{\}}

}
