% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riemann_sum_1d_plot.R
\name{riemann_sum_1d_plot}
\alias{riemann_sum_1d_plot}
\title{1D Riemann sums with optional plot}
\usage{
riemann_sum_1d_plot(
  f,
  xlim,
  n = 12L,
  methods = c("lower", "upper", "mid"),
  show_curve = TRUE,
  curve_res = 400L,
  colors = list(lower = "#a1d99b", upper = "#fc9272", mid = "#9ecae1"),
  alpha = 0.8,
  edge_color = "black",
  edge_width = 1.2,
  curve_color = "black",
  curve_width = 2,
  show_baseline = TRUE,
  baseline = 0,
  baseline_color = "gray50",
  baseline_width = 1,
  warn_heavy = TRUE
)
}
\arguments{
\item{f}{Function \code{function(x)} returning numeric values.}

\item{xlim}{Numeric vector \code{c(xmin, xmax)} with \code{xmax > xmin}.}

\item{n}{Integer. Number of subintervals.}

\item{methods}{Character vector with any of \code{"lower"}, \code{"upper"},
\code{"mid"} indicating which rectangle types to draw.}

\item{show_curve}{Logical. If \code{TRUE}, overlays the curve \code{f(x)}.}

\item{curve_res}{Integer. Number of points used to draw the curve.}

\item{colors}{Named list specifying fill colors for
\code{list(lower=..., upper=..., mid=...)}.}

\item{alpha}{Numeric in \code{[0,1]}. Fill opacity for rectangles.}

\item{edge_color}{Color for rectangle borders.}

\item{edge_width}{Border width.}

\item{curve_color}{Color for the curve.}

\item{curve_width}{Line width for the curve.}

\item{show_baseline}{Logical. If \code{TRUE}, draws a horizontal baseline.}

\item{baseline}{Numeric. Y-value for the baseline.}

\item{baseline_color}{Baseline color.}

\item{baseline_width}{Baseline width.}

\item{warn_heavy}{Logical. If \code{TRUE}, warns when \code{n} is very large.}
}
\value{
A list with components:
\itemize{
\item \code{lower_sum} Lower Riemann sum.
\item \code{upper_sum} Upper Riemann sum.
\item \code{mid_sum} Midpoint Riemann sum.
\item \code{dx} Subinterval width.
\item \code{x_breaks} Partition points.
\item \code{figure} A plotly object, or \code{NULL} if not available.
}
}
\description{
Computes lower, upper, and midpoint Riemann sums for a scalar function
\code{f(x)} on an interval \code{[xmin, xmax]}. Optionally draws a
2D plot with rectangles and, if requested, the true curve.
}
\examples{
f <- function(x) sin(2*x)
out <- riemann_sum_1d_plot(
  f, xlim = c(0, pi), n = 10,
  methods = c("lower","upper","mid"),
  show_curve = TRUE
)
out$mid_sum

}
