% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour_input_geometry.R
\name{vapour_layer_info}
\alias{vapour_layer_info}
\title{Read GDAL layer info}
\usage{
vapour_layer_info(
  dsource,
  layer = 0L,
  sql = "",
  extent = NA,
  count = TRUE,
  ...
)
}
\arguments{
\item{dsource}{data source name (path to file, connection string, URL)}

\item{layer}{integer of layer to work with, defaults to the first (0) or the name of the layer}

\item{sql}{if not empty this is executed against the data source (layer will be ignored)}

\item{extent}{apply an arbitrary extent, only when 'sql' used (must be 'ex = c(xmin, xmax, ymin, ymax)' but sp bbox, sf bbox, and raster extent also accepted)}

\item{count}{logical to control if count calculated and returned, TRUE by default (set to FALSE to avoid the extra calculation and missing value is the result)}

\item{...}{unused, reserved for future use}
}
\value{
list with a list of character vectors of projection metadata, see details
}
\description{
Read GDAL layer information for a vector data source.
}
\details{
Set \code{extent} and/or \code{count} to \code{FALSE} to avoid calculating them if not needed, it might take some time.

The layer information elements are

\describe{
\item{dsn}{the data source name}
\item{driver}{the short name of the driver used}
\item{layer}{the name of the layer queried}
\item{layer_names}{the name/s of all available layers (see \link{vapour_layer_names})}
\item{fields}{a named vector of field types (see \link{vapour_report_fields})}
\item{count}{the number of features in this data source (can be turned off to avoid the extra work \code{count})}
\item{extent}{the extent of all features xmin, xmax, ymin, ymax (can be turned off to avoid the extra work \code{extent})}
\item{projection}{a list of character strings, see next}
}

\verb{$projection} is a list of various formats of the projection metadata.
Use \verb{$projection$Wkt} as most authoritative, but we don't enter into the discussion or limit what
might be done with this (that's up to you). Currently we see
\code{c("Proj4", "MICoordSys", "PrettyWkt", "Wkt", "EPSG", "XML")} as names of this \verb{$projection} element.

To get the geometry type/s of a layer see \code{\link[=vapour_read_type]{vapour_read_type()}}.
}
\examples{
file <- "list_locality_postcode_meander_valley.tab"
## A MapInfo TAB file with polygons
mvfile <- system.file(file.path("extdata/tab", file), package="vapour")
info <- vapour_layer_info(mvfile)
names(info$projection)

## info depends on the query/spatial-filter
vapour_layer_info(mvfile, extent = c(412000,  420000, 5352612.8, 5425154.3), 
  sql = "SELECT * FROM list_locality_postcode_meander_valley")$count
}
\seealso{
vapour_geom_name vapour_layer_names vapour_report_fields vapour_read_fields vapour_driver vapour_read_names
}
