% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_aug_awaresmooth.R
\name{ts_aug_awaresmooth}
\alias{ts_aug_awaresmooth}
\title{Augmentation by Awareness Smooth}
\usage{
ts_aug_awaresmooth(factor = 1)
}
\arguments{
\item{factor}{Numeric factor controlling the recency weighting.}
}
\value{
A \code{ts_aug_awaresmooth} object.
}
\description{
Recency-aware augmentation that also progressively smooths noise
before applying the weighting, producing cleaner augmented samples.
}
\examples{
# Recency-aware augmentation with progressive smoothing
# Load package and example dataset
library(daltoolbox)
data(tsd)

# Convert to 10-lag sliding windows and preview
xw <- ts_data(tsd$y, 10)
ts_head(xw)

# Apply awareness+smooth augmentation and inspect result
augment <- ts_aug_awaresmooth()
augment <- fit(augment, xw)
xa <- transform(augment, xw)
ts_head(xa)
}
\references{
\itemize{
\item Q. Wen et al. (2021). Time Series Data Augmentation for Deep Learning:
A Survey. IJCAI Workshop on Time Series.
}
}
