% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.3.0.R
\name{predict.tsarima}
\alias{predict.tsarima}
\alias{predict}
\alias{predict.tsesm}
\alias{print.tspredict}
\alias{predict.tslm}
\title{Predict Time Series Values}
\usage{
\method{predict}{tsarima}(
  object,
  n.ahead = 1L,
  newxreg = NULL,
  newxreg.est = c("none", "x", "auto.arima"),
  se.fit = TRUE,
  alpha = 0.05,
  log = NULL,
  ...
)

\method{predict}{tsesm}(object, n.ahead = 1L, se.fit = TRUE, alpha = 0.05, ...)

\method{print}{tspredict}(x, ...)

\method{predict}{tslm}(object, n.ahead = 1L, se.fit = TRUE, alpha = 0.05, ...)
}
\arguments{
\item{object}{a time series or time series model for which prediction is required.}

\item{n.ahead}{number of forecasting periods. Default is \code{1}.}

\item{newxreg}{new values of the regressors. Only necessary if ARIMA model is built with independent variables.}

\item{newxreg.est}{character strings to indicate how the new values of the regressors in an ARIMAX model should be estimated in case they are not yet available. If \code{newxreg} is not \code{NULL}, this argument will be ignored. Available options are `\code{none}`, `\code{x}`, and `\code{auto.arima}`. The option `\code{none}` means that no estimation is needed, and the regressors will have no effect in future forecasts. The option `\code{x}` means that the regressors' value will forecasted based on the same model as `\code{x}`. The option `\code{auto.arima}` means that the regressors' value will forecasted based on the best model found by \code{auto.arima()}. Default is `\code{none}`.}

\item{se.fit}{logical. If \code{TRUE}, standard error of each prediction will be calculated and included. Default is \code{TRUE}.}

\item{alpha}{significance level. (1 - \code{alpha}) indicates is the confidence level of the prediction interval. Default is \code{0.05}.}

\item{log}{optional. A logical value indicating whether the forecasted values are log-transformed and should be inverted back to the original series scale. If the object is an \code{tsarima} model and this parameter is omitted, the value will be taken over by the settings of the model given in object. Default is \code{NULL} here.}

\item{...}{additional arguments affecting the forecasts produced.}

\item{x}{a `\code{tspredict}` object.}
}
\value{
An object of class "\code{tspredict}".

The function \code{print} is used to obtain and print the prediction results, including the predicted values, the corresponding standard errors, as well as the lower and upper limit of the prediction intervals.

An object of class "\code{tspredict}" is a list usually containing the following elements:

\item{x.time}{list of time in which the series values were observed.}

\item{x.timegap}{time gap between the series and forecasted values.}

\item{x.name}{name of the time series for which forecasts was requested.}

\item{pred}{predicted past values and forecasted future values.}

\item{se}{standard errors of the forecasted values.}

\item{cil, ciu}{lower and upper limits of the prediction interval.}

\item{n.ahead}{number of forecasting periods.}

\item{log}{logical. Indicates whether series values are log-transformed for model fitting or not. (Only available for class "\code{tsarima}")}

\item{alpha}{significance level.}
}
\description{
The function `\code{predict}` is generic and predicts past/future values of a time series.
}
\examples{
predict(tsarima(airport$Travellers, order = c(1, 1, 0), 
                seasonal = c(0, 1, 1), log = TRUE, include.const = TRUE),
        n.ahead = 6, alpha = 0.05)

predict(tsesm(airport$Travellers, order = "holt-winters"), 
        n.ahead = 6, alpha = 0.05)
}
\references{
Box, G. E. P., & Jenkins, G. M. (1970). Time series analysis: Forecasting and control. Holden-Day.

Hyndman, R. J., & Athanasopoulos, G. (2021). Forecasting: Principles and practice (3rd ed.). OTexts. \cr \url{https://otexts.com/fpp3/}
}
\author{
Ka Yui Karl Wu
}
