% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_logging_functions.R
\name{set.logging.functions}
\alias{set.logging.functions}
\title{Sets the logging functions that shall be used by \code{tryCatchLog} for the different severity levels}
\usage{
set.logging.functions(
  error.log.func = function(msg) tryCatchLog::log2console("ERROR", msg),
  warn.log.func = function(msg) tryCatchLog::log2console("WARN", msg),
  info.log.func = function(msg) tryCatchLog::log2console("INFO", msg),
  logger.package.name = "tryCatchLog"
)
}
\arguments{
\item{error.log.func}{The logging function for errors}

\item{warn.log.func}{The logging function for warning}

\item{info.log.func}{The error function for messages}

\item{logger.package.name}{The logging package name of the functions (just internally used to print the name).
For self-made logging functions (not part of a package) should use "custom functions"
but can use any other name (it has no functionality).}
}
\value{
Nothing
}
\description{
The logging functions must have at least one parameter: The logging message (as character)
which must be the first argument.
}
\details{
The default logging functions are internal functions without any dependencies to other
logging packages. They use the same logging output format as \pkg{futile.logger} version 1.4.3.

If you want to disable any logging output you should use a decent logging framework
which allows to set the logging threshold (e. g. futile.logger's \code{\link[futile.logger]{flog.threshold}}).

The package-internal default logging functions are only a minimal implementation
and are not meant to replace a decent logging framework.

To activate another logging package that is supported by \code{tryCatchLog} use \code{\link{set.logging.package}}.
}
\examples{
# To disable any logging you could use "empty" functions
set.logging.functions( error.log.func = function(msg) invisible(),
                       warn.log.func  = function(msg) invisible(),
                       info.log.func  = function(msg) invisible())

}
\seealso{
\code{\link{tryCatchLog}}
         \code{\link{set.logging.package}}
}
