% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_dr_rc.R
\name{att_dr_rc}
\alias{att_dr_rc}
\title{Doubly robust DDD estimator for ATT, with repeated cross-section data and 2 periods}
\usage{
att_dr_rc(did_preprocessed)
}
\arguments{
\item{did_preprocessed}{A list containing preprocessed data and specifications for the DDD estimation.
Expected elements include:
- \code{preprocessed_data}: A data table containing the data with variables needed for the analysis.
- \code{est_method}: The estimation method to be used. Default is \code{est_method = "dr"}.
- \code{xformula}: The formula for the covariates to be included in the model. It should be of the form \code{~ x1 + x2}.
Default is \code{xformla = ~1} (no covariates).
- \code{boot}: Logical. If \code{TRUE}, the function use the multiplier bootstrap to compute standard errors. Default is \code{FALSE}.
- \code{nboot}: The number of bootstrap samples to be used. Default is \code{NULL}. If \code{boot = TRUE}, the default is \code{nboot = 999}.
- \code{subgroup_counts}: A matrix containing the number of observations in each subgroup.
- \code{alpha} The level of significance for the confidence intervals.  Default is \code{0.05}.
- \code{inffunc}: Logical. If \code{TRUE}, the function returns the influence function. Default is \code{FALSE}.
- \code{use_parallel}: Boolean of whether or not to use parallel processing in the multiplier bootstrap, default is \code{use_parallel=FALSE}
- \code{cores}: the number of cores to use with parallel processing, default is \code{cores=1}
- \code{cband}: Boolean of whether or not to compute simultaneous confidence bands, default is \code{cband=FALSE}}
}
\value{
A list with the estimated ATT, standard error, upper and lower confidence intervals, and influence function.
}
\description{
This function implements a doubly robust estimator for assessing the average
treatment effect on the treated (ATT) using a triple differences (DDD) approach
in repeated cross-section data settings across two time periods. The function takes preprocessed
data structured specifically for this analysis.
}
\keyword{internal}
