% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vision_utils.R
\name{draw_keypoints}
\alias{draw_keypoints}
\title{Draws Keypoints}
\usage{
draw_keypoints(
  image,
  keypoints,
  connectivity = NULL,
  colors = NULL,
  radius = 2,
  width = 3
)
}
\arguments{
\item{image}{Tensor of shape (3 x H x W) and dtype \code{uint8} or dtype \code{float}.
In case of dtype float, values are assumed to be in range \eqn{[0, 1]}.}

\item{keypoints}{Tensor of shape (N, K, 2) the K keypoints location for each of the N detected poses instance,}

\item{connectivity}{Vector of pair of keypoints to be connected (currently unavailable)}

\item{colors}{character vector containing the colors
of the boxes or single color for all boxes. The color can be represented as
strings e.g. "red" or "#FF00FF". By default, viridis colors are generated for keypoints}

\item{radius}{radius of the plotted keypoint.}

\item{width}{width of line connecting keypoints.}
}
\value{
Image Tensor of dtype uint8 with keypoints drawn.
}
\description{
Draws Keypoints, an object describing a body part (like rightArm or leftShoulder), on given RGB tensor image.
}
\examples{
if (torch::torch_is_installed()) {
\dontrun{
image <- torch::torch_randint(190, 255, size = c(3, 360, 360))$to(torch::torch_uint8())
keypoints <- torch::torch_randint(low = 60, high = 300, size = c(4, 5, 2))
keypoint_image <- draw_keypoints(image, keypoints)
tensor_image_browse(keypoint_image)
}
}
}
\seealso{
Other image display: 
\code{\link{draw_bounding_boxes}()},
\code{\link{draw_segmentation_masks}()},
\code{\link{tensor_image_browse}()},
\code{\link{tensor_image_display}()},
\code{\link{vision_make_grid}()}
}
\concept{image display}
