% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-transformer.R
\name{nn_transformer_encoder}
\alias{nn_transformer_encoder}
\title{Transformer Encoder Module (R torch)}
\usage{
nn_transformer_encoder(encoder_layer, num_layers, norm = NULL)
}
\arguments{
\item{encoder_layer}{(nn_module) an instance of \code{nn_transformer_encoder_layer} (or compatible) that defines the layer to be repeated.}

\item{num_layers}{(integer) the number of encoder layers to stack.}

\item{norm}{(nn_module or NULL) optional layer normalization module to apply after the last layer (e.g., \code{nn_layer_norm}). Default: NULL (no extra normalization).}
}
\value{
An \code{nn_module} of class \code{nn_transformer_encoder}. Calling it on an input tensor of shape \verb{(S, N, E)} or \verb{(N, S, E)} (depending on \code{batch_first}) returns the encoded output of the same shape.
}
\description{
Implements a stack of transformer encoder layers, optionally with a final layer normalization.
}
\details{
This module replicates the given \code{encoder_layer} \code{num_layers} times to construct the Transformer encoder.
If a \code{norm} module is provided, it will be applied to the output of the final encoder layer.
The forward pass sequentially applies each encoder layer to the input.
}
\examples{
if (torch_is_installed()) {
if (torch_is_installed()) {
  layer <- nn_transformer_encoder_layer(d_model = 32, nhead = 4, batch_first = TRUE)
  model <- nn_transformer_encoder(layer, num_layers = 2)
  x <- torch_randn(8, 5, 32) # (batch, seq, feature) since batch_first=TRUE
  y <- model(x) # output shape is (8, 5, 32)
}
}
}
