% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{nn_module_dict}
\alias{nn_module_dict}
\title{Container that allows named values}
\usage{
nn_module_dict(dict)
}
\arguments{
\item{dict}{A named list of submodules that will be saved in that module.}
}
\description{
Container that allows named values
}
\examples{
if (torch_is_installed()) {
nn_module <- nn_module(
  initialize = function() {
    self$dict <- nn_module_dict(list(
      l1 = nn_linear(10, 20),
      l2 = nn_linear(20, 10)
    ))
  },
  forward = function(x) {
    x <- self$dict$l1(x)
    self$dict$l2(x)
  }
)
}
}
\seealso{
\code{\link[=nn_module_list]{nn_module_list()}}
}
