% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_3d_mapping}
\alias{plot_3d_mapping}
\title{Create 3D Visualization}
\usage{
plot_3d_mapping(
  df,
  ndim,
  dim_config = new_dim_reduction_config(),
  aesthetic_config = new_aesthetic_config(),
  layout_config = new_layout_config(),
  interactive = TRUE,
  output_dir
)
}
\arguments{
\item{df}{Data frame containing:
- V1, V2, ... Vn: Coordinate columns
- antigen: Binary indicator for antigen points
- antiserum: Binary indicator for antiserum points
- cluster: (Optional) Factor or integer cluster assignments
- year: (Optional) Numeric year values for temporal coloring}

\item{ndim}{Number of dimensions in input coordinates (must be >= 3)}

\item{dim_config}{Dimension reduction configuration object}

\item{aesthetic_config}{Aesthetic configuration object}

\item{layout_config}{Layout configuration object}

\item{interactive}{Logical; whether to create an interactive plot}

\item{output_dir}{Character. Directory for output files. Required if \code{interactive} is \code{FALSE}.}
}
\value{
Invisibly returns the rgl scene ID for further manipulation if rgl is
available, or a 2D ggplot object as a fallback.
}
\description{
Creates an interactive or static 3D visualization using rgl. Supports both
temporal and cluster-based coloring schemes with configurable point
appearances and viewing options.
}
\details{
The function supports two main visualization modes:
\enumerate{
\item Interactive mode: Creates a manipulatable 3D plot window
\item Static mode: Generates a static image from a fixed viewpoint
}

Color schemes are automatically selected based on available data:
\itemize{
\item If cluster data is present: Uses discrete colors per cluster
\item If year data is present: Uses continuous color gradient
\item Otherwise: Uses default point colors
}

For data with more than 3 dimensions, dimension reduction is applied first.

Note: This function requires the rgl package and OpenGL support. If rgl is not
available, the function will return a 2D plot with a message explaining how to
enable 3D visualization.
}
\examples{
# Create sample data
set.seed(123)
data <- data.frame(
  V1 = rnorm(100), V2 = rnorm(100), V3 = rnorm(100), V4 = rnorm(100), name = 1:100,
  antigen = rep(c(0,1), 50), antiserum = rep(c(1,0), 50),
  cluster = rep(1:5, each=20), year = rep(2000:2009, each=10)
)

# Create a static plot and save to a temporary file
# This example requires an interactive session and the 'rgl' package.
if (interactive() && requireNamespace("rgl", quietly = TRUE)) {
  temp_dir <- tempdir()
  # Basic interactive plot (will open a new window)
  if(interactive()) {
    plot_3d_mapping(data, ndim=4)
  }

# Custom configuration for temporal visualization
aesthetic_config <- new_aesthetic_config(
  point_size = 5,
  point_alpha = 0.8,
  gradient_colors = list(
    low = "blue",
    high = "red"
  )
)

layout_config <- new_layout_config(
  width = 12,
  height = 12,
  background_color = "black",
  show_axis = TRUE
)
  # Create customized static plot and save it
plot_3d_mapping(data, ndim=4,
  aesthetic_config = aesthetic_config,
  layout_config = layout_config,
  interactive = FALSE, output_dir = temp_dir
)
  list.files(temp_dir)
  unlink(temp_dir, recursive = TRUE)
}

}
\seealso{
\code{\link{plot_temporal_mapping}} for 2D temporal visualization
\code{\link{plot_cluster_mapping}} for 2D cluster visualization
\code{\link{make_interactive}} for converting 2D plots to interactive versions
}
