% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_model_based.R
\name{impute_model}
\alias{impute_model}
\title{Model-based imputation from parametric distributions}
\usage{
impute_model(
  dat,
  reason,
  impute,
  imputation_model = c("weibull", "exponential"),
  alpha,
  J,
  seed = 12345
)
}
\arguments{
\item{dat}{data.frame containing at least 5 columns: TRT01P (treatment arm as factor), AVAL (survival time), EVENT (event indicator), CNSRRS (censoring reason) and MAXAVAL (maximum potential survival time, duration between randomization to data cut-off)}

\item{reason}{a string specifying the censoring reasons which require imputation. It must be one of the reasons from variable CNSRRS.}

\item{impute}{a string specifying the treatment arm(s) which require imputation. It must be one of the arms from variable TRT01P, the first level of TRT01P is considered as the control arm.}

\item{imputation_model}{a string specifying the parametric distribution used for imputation, can be "Weibull" or "exponential".}

\item{alpha}{hazard inflation (if treatment arm is imputed) or deflation (if control arm is imputed) rate}

\item{J}{numeric indicating number of imputations.}

\item{seed}{Integer. Random seed for reproducibility.}
}
\value{
a list of data.frame from each imputation with imputed AVAL and EVENT, where original variables are kept as AVALo and EVENTo.
}
\description{
Impute data with Weibull or exponential distribution conditional on follow-up time
}
\details{
First fit model based on the data without dropout. And then impute the the survival outcome based on exponential or Weibull distribution for those who dropped out.
}
\keyword{internal}
