% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_ts}
\alias{plot_ts}
\title{Interactive plot for time-series tibbles}
\usage{
plot_ts(
  df,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  legend_show = "auto",
  legend_width = 250,
  group = NULL,
  width = NULL,
  height = NULL,
  ...
)
}
\arguments{
\item{df}{data.frame or tibble, first column of name \code{datetime} being of class datetime and rest of columns being numeric}

\item{title}{character, title of the plot (accepts HTML code)}

\item{xlab}{character, X axis label (accepts HTML code)}

\item{ylab}{character, Y axis label (accepts HTML code)}

\item{legend_show}{character, when to display the legend.
Specify "always" to always show the legend.
Specify "onmouseover" to only display it when a user mouses over the chart.
Specify "follow" to have the legend show as overlay to the chart which follows the mouse.
The default behavior is "auto", which results in "always" when more than one series
is plotted and "onmouseover" when only a single series is plotted.}

\item{legend_width}{integer, width (in pixels) of the div which shows the legend.}

\item{group}{character, dygraphs group to associate this plot with. The x-axis zoom level of dygraphs plots within a group is automatically synchronized.}

\item{width}{Width in pixels (optional, defaults to automatic sizing)}

\item{height}{Height in pixels (optional, defaults to automatic sizing)}

\item{...}{extra arguments to pass to \code{dygraphs::dyOptions} function.}
}
\value{
dygraph
}
\description{
First column of the \code{df} tibble must be a \code{datetime} or date variable.
The rest of columns must be numeric of the same units. This functions makes
use of \code{dygraphs} package to generate an HTML dygraphs plot.
}
\examples{
plot_ts(dtf, ylab = "kW", legend_show = "onmouseover")

}
