% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_gaps.R
\name{fill_na}
\alias{fill_na}
\title{Fill gaps with a specific value}
\usage{
fill_na(dtf, varnames, with = 0)
}
\arguments{
\item{dtf}{data.frame or tibble, first column of name \code{datetime} being
of class datetime and rest of columns being numeric}

\item{varnames}{character or vector of characters,
column names with NA values}

\item{with}{numeric, value to fill NA values}
}
\value{
tibble or data.frame
}
\description{
This is useful when the gaps in a numeric timeseries can be
filled with the same number (e.g. zero)
}
\examples{
past_data <- data.frame(
  datetime = as.POSIXct("2024-01-01 00:00:00", tz = "UTC") + 0:3 * 3600,
  consumption = c(1.2, NA, NA, 2.5)
)
fill_na(past_data, "consumption", with = 0)

}
