% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niche_overlap.R
\name{niche_overlap}
\alias{niche_overlap}
\title{Compute overlap metrics of the two niches}
\usage{
niche_overlap(x, y, method = c("Schoener", "Hellinger"))
}
\arguments{
\item{x}{a \link[terra:SpatRaster-class]{terra::SpatRaster} with a single layer}

\item{y}{a \link[terra:SpatRaster-class]{terra::SpatRaster} with a single layer}

\item{method}{a string (or vector of strings) taking values "Schoener" and
"Hellinger"}
}
\value{
a list of overlap metrics, with slots \emph{D} and \emph{I} (depending on
\code{method})
}
\description{
This function computes overlap metrics between two rasters. It currently
implements Schoener's D and the inverse I of Hellinger's distance.
}
\details{
Note that Hellinger's distance is normalised by dividing by square root of 2
(which is the correct asymptote for Hellinger's D), rather than the incorrect
2 used originally in Warren et al (2008), based on the Erratum for that
paper.
}
\references{
Warren, D.L., Glor, R.E. & Turelli M. (2008) Environmental niche
equivalency versus conservativism: quantitative approaches to niche
evolution. Evolution 62: 2868-2883
}
