# bad inputs generate errors

    Code
      unnest(df, y)
    Condition
      Error in `list_sizes()`:
      ! `x[[1]]` must be a vector, not a function.

# multiple columns must be same length

    Code
      unnest(df, c(x, y))
    Condition
      Error in `unnest()`:
      ! In row 1, can't recycle input of size 2 to size 3.

---

    Code
      unnest(df, c(x, y))
    Condition
      Error in `unnest()`:
      ! In row 1, can't recycle input of size 2 to size 3.

# unnesting column of mixed vector / data frame input is an error

    Code
      unnest(df, x)
    Condition
      Error in `unnest()`:
      ! Can't combine `x[[1]]` <double> and `x[[2]]` <tbl_df>.

# unnest() advises on outer / inner name duplication

    Code
      unnest(df, y)
    Condition
      Error in `unnest()`:
      ! Can't duplicate names between the affected columns and the original data.
      x These names are duplicated:
        i `x`, from `y`.
      i Use `names_sep` to disambiguate using the column name.
      i Or use `names_repair` to specify a repair strategy.

# unnest() advises on inner / inner name duplication

    Code
      unnest(df, c(x, y))
    Condition
      Error in `unnest()`:
      ! Can't duplicate names within the affected columns.
      x These names are duplicated:
        i `a`, within `x` and `y`.
      i Use `names_sep` to disambiguate using the column name.
      i Or use `names_repair` to specify a repair strategy.

# unnest() disallows renaming

    Code
      unnest(df, c(y = x))
    Condition
      Error in `unnest()`:
      ! Can't rename variables in this context.

# cols must go in cols

    Code
      unnest(df, x, y)
    Condition
      Warning:
      `unnest()` has a new interface. See `?unnest` for details.
      i Try `df |> unnest(c(x, y))`, with `mutate()` if needed.
    Output
      # A tibble: 2 x 2
            x y    
        <dbl> <chr>
      1     3 a    
      2     4 b    

# need supply column names

    Code
      unnest(df)
    Condition
      Warning:
      `cols` is now required when using `unnest()`.
      i Please use `cols = c(y)`.
    Output
      # A tibble: 2 x 2
            x y    
        <int> <chr>
      1     1 a    
      2     2 b    

# sep combines column names

    Code
      out <- unnest(df, c(x, y), .sep = "_")
    Condition
      Warning:
      The `.sep` argument of `unnest()` is deprecated as of tidyr 1.0.0.
      i Use `names_sep = '_'` instead.

# unnest has mutate semantics

    Code
      out <- unnest(df, z = map(y, `+`, 1))
    Condition
      Warning:
      `unnest()` has a new interface. See `?unnest` for details.
      i Try `df |> unnest(c(z))`, with `mutate()` if needed.

# .drop and .preserve are deprecated

    Code
      unnest(df, x, .preserve = y)
    Condition
      Warning:
      The `.preserve` argument of `unnest()` is deprecated as of tidyr 1.0.0.
      i All list-columns are now preserved
    Output
      # A tibble: 2 x 2
            x y        
        <dbl> <list>   
      1     3 <chr [1]>
      2     4 <chr [1]>

---

    Code
      unnest(df, x, .drop = FALSE)
    Condition
      Warning:
      The `.drop` argument of `unnest()` is deprecated as of tidyr 1.0.0.
      i All list-columns are now preserved.
    Output
      # A tibble: 2 x 2
            x y        
        <dbl> <list>   
      1     3 <chr [1]>
      2     4 <chr [1]>

# .id creates vector of names for vector unnest

    Code
      out <- unnest(df, y, .id = "name")
    Condition
      Warning:
      The `.id` argument of `unnest()` is deprecated as of tidyr 1.0.0.
      i Manually create column of names instead.

