% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_ploidy.R
\name{show_ploidy}
\alias{show_ploidy}
\alias{show_ploidy.tbl_df}
\alias{show_ploidy.vctrs_bigSNP}
\title{Show the ploidy information of a \code{gen_tibble}}
\usage{
show_ploidy(.x, ...)

\method{show_ploidy}{tbl_df}(.x, ...)

\method{show_ploidy}{vctrs_bigSNP}(.x, ...)
}
\arguments{
\item{.x}{a vector of class \code{vctrs_bigSNP} (usually the \code{genotype} column of
a \code{\link{gen_tibble}} object),
or a \code{\link{gen_tibble}}.}

\item{...}{currently unused.}
}
\value{
the ploidy (0 indicates mixed ploidy)
}
\description{
Extract the ploidy information from a  \code{gen_tibble}. NOTE that this function
does not return the ploidy level for each individual (that is obtained with
\code{\link{indiv_ploidy}}); instead, it returns an integer which is either the ploidy
level of all individuals (e.g. 2 indicates all individuals are diploid),
or a 0 to indicate mixed ploidy. The special case of -2 is used to indicate
the presence of pseudo-haploids (i.e. individuals with a ploidy of 2 but
for which we only have information for one allele; the dosages are 0 or 2
for these individuals).
}
\examples{
example_gt <- load_example_gt("gen_tbl")

example_gt \%>\% show_ploidy()
}
\seealso{
\code{\link[=indiv_ploidy]{indiv_ploidy()}}
}
