% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_deepseek.R
\name{deepseek_chat}
\alias{deepseek_chat}
\title{Send LLM Messages to the DeepSeek Chat API}
\usage{
deepseek_chat(
  .llm,
  .model = "deepseek-chat",
  .max_tokens = 2048,
  .temperature = NULL,
  .top_p = NULL,
  .frequency_penalty = NULL,
  .presence_penalty = NULL,
  .stop = NULL,
  .stream = FALSE,
  .logprobs = NULL,
  .top_logprobs = NULL,
  .tools = NULL,
  .tool_choice = NULL,
  .api_url = "https://api.deepseek.com/",
  .timeout = 60,
  .verbose = FALSE,
  .dry_run = FALSE,
  .max_tries = 3
)
}
\arguments{
\item{.llm}{An \code{LLMMessage} object containing the conversation history.}

\item{.model}{The identifier of the model to use (default: "deepseek-chat").}

\item{.max_tokens}{The maximum number of tokens that can be generated in the response (default: 2048).}

\item{.temperature}{Controls the randomness in the model's response. Values between 0 and 2 are allowed (optional).}

\item{.top_p}{Nucleus sampling parameter that controls the proportion of probability mass considered (optional).}

\item{.frequency_penalty}{Number between -2.0 and 2.0. Penalizes repeated tokens to reduce repetition (optional).}

\item{.presence_penalty}{Number between -2.0 and 2.0. Encourages new topics by penalizing tokens that have appeared so far (optional).}

\item{.stop}{One or more sequences where the API will stop generating further tokens (optional).}

\item{.stream}{Logical; if TRUE, streams the response piece by piece (default: FALSE).}

\item{.logprobs}{If TRUE, returns log probabilities of each output token (default: FALSE).}

\item{.top_logprobs}{Number between 0 and 5 specifying the number of top log probabilities to return (optional).}

\item{.tools}{Either a single TOOL object or a list of TOOL objects representing the available functions for tool calls.}

\item{.tool_choice}{A character string specifying the tool-calling behavior; valid values are \code{"none"}, \code{"auto"}, or \code{"required"} (optional).}

\item{.api_url}{Base URL for the DeepSeek API (default: \code{"https://api.deepseek.com/"}).}

\item{.timeout}{Request timeout in seconds (default: 60).}

\item{.verbose}{If TRUE, displays additional information after the API call (default: FALSE).}

\item{.dry_run}{If TRUE, returns the constructed request object without executing it (default: FALSE).}

\item{.max_tries}{Maximum retries to perform the request (default: 3).}
}
\value{
A new \code{LLMMessage} object containing the original messages plus the assistant's response.
}
\description{
This function sends a message history to the DeepSeek Chat API and returns the assistant's reply.
Currently tool calls cause problems on the DeepSeek API
}
