% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_simple_thresholds.R
\name{mx_data_quantiles}
\alias{mx_data_quantiles}
\title{Data Quantiles}
\usage{
mx_data_quantiles(df)
}
\arguments{
\item{df}{A \code{data.frame} with only columns of class \code{ordered}.}
}
\value{
A matrix with the appropriate dimensions for the threshold matrix for
\code{df}, see \code{\link[OpenMx:mxThreshold]{OpenMx::mxThreshold()}}.
}
\description{
Get quantiles based on empirical normal distribution of data.
}
\examples{
set.seed(1)
df <- data.frame(X = ordered(sample(c(1:4), size = 100, replace = TRUE,
prob = c(.1, .2, .5, .2))))
mx_data_quantiles(df)
}
