% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/try-again.R
\name{try_again}
\alias{try_again}
\title{Evaluate an expectation multiple times until it succeeds}
\usage{
try_again(times, code)
}
\arguments{
\item{times}{Number of times to retry.}

\item{code}{Code to evaluate.}
}
\description{
If you have a flaky test, you can use \code{try_again()} to run it a few times
until it succeeds. In most cases, you are better fixing the underlying
cause of the flakeyness, but sometimes that's not possible.
}
\examples{
usually_return_1 <- function(i) {
  if (runif(1) < 0.1) 0 else 1
}

\dontrun{
# 10\% chance of failure:
expect_equal(usually_return_1(), 1)

# 1\% chance of failure:
try_again(1, expect_equal(usually_return_1(), 1))

# 0.1\% chance of failure:
try_again(2, expect_equal(usually_return_1(), 1))
}
}
