% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-all.R
\name{expect_all_equal}
\alias{expect_all_equal}
\alias{expect_all_true}
\alias{expect_all_false}
\title{Do you expect every value in a vector to have this value?}
\usage{
expect_all_equal(object, expected)

expect_all_true(object)

expect_all_false(object)
}
\arguments{
\item{object, expected}{Computation and value to compare it to.

Both arguments supports limited unquoting to make it easier to generate
readable failures within a function or for loop. See \link{quasi_label} for
more details.}
}
\description{
These expectations are similar to \code{expect_true(all(x == "x"))},
\code{expect_true(all(x))} and \code{expect_true(all(!x))} but give more informative
failure messages if the expectations are not met.
}
\examples{
x1 <- c(1, 1, 1, 1, 1, 1)
expect_all_equal(x1, 1)

x2 <- c(1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2)
show_failure(expect_all_equal(x2, 1))

# expect_all_true() and expect_all_false() are helpers for common cases
set.seed(1016)
show_failure(expect_all_true(rpois(100, 10) < 20))
show_failure(expect_all_false(rpois(100, 10) > 20))
}
