% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-filter.R
\name{chk-helper}
\alias{chk-helper}
\alias{chk_filter}
\alias{chk_filter_all}
\alias{chk_filter_any}
\title{Checks: data frame helpers}
\usage{
chk_filter(data, vars, func, flt = TRUE, args = list())

chk_filter_all(data, vars, func, flt = TRUE, args = list())

chk_filter_any(data, vars, func, flt = TRUE, args = list())
}
\arguments{
\item{data}{A data frame to check.}

\item{vars}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns to
check.}

\item{func}{A function to use for checking that takes a vector as the first
argument and returns a logical vector of the same length showing whether an
element passed or failed.}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{args}{A list of additional arguments to be added to the function calls.}
}
\value{
A logical vector or data frame of logical vectors flagging records
that have passed or failed the check, with \code{NA} where records do not meet
the filter condition.
}
\description{
These helper functions allowing easy checking using an arbitrary function
(\code{func}) over multiple columns (\code{vars}) of a data frame (\code{data}), with an
optional filter (\code{flt}).
}
\details{
\itemize{
\item \code{chk_filter()} applies \code{func} with \code{args} to \code{vars} in \code{data} filtered
with \code{flt} and returns a data frame containing the resulting logical vectors.
\item \code{chk_filter_all()} and \code{chk_filter_any()} both run \code{chk_filter()} and
return a single logical vector flagging whether \emph{all} or \emph{any} values in each
row are \code{TRUE} (i.e. the conjunction and disjunction, respectively, of the
columns in the output of \code{chk_filter()}).
}
}
\examples{

# Check that every 4-cylinder car has an engine displacement of < 100 cubic
# inches AND < 100 horsepower - return a data frame
chk_filter(
  mtcars,
  c("disp", "hp"),
  chk_range,
  cyl == 4,
  list(min = 0, max = 100)
)

# Check that every 4-cylinder car has an engine displacement of < 100 cubic
# inches AND < 100 horsepower
chk_filter_all(
  mtcars,
  c("disp", "hp"),
  chk_range,
  cyl == 4,
  list(min = 0, max = 100)
)

# Check that every 4-cylinder car has an engine displacement of < 100 cubic
# inches OR < 100 horsepower
chk_filter_any(
  mtcars,
  c("disp", "hp"),
  chk_range,
  cyl == 4,
  list(min = 0, max = 100)
)

# Check that columns made up of whole numbers are binary
chk_filter_all(
  mtcars,
  where(~ all(. \%\% 1 == 0)),
  chk_values,
  TRUE,
  list(0:1)
)

}
\seealso{
Other \verb{chk_*()} functions such as \code{\link[=chk-values]{chk_values()}}
}
